/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import com.ibm.icu.util.ULocale;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.device.IScriptMenuHelper;
import org.eclipse.birt.chart.device.ScriptMenuHelper;
import org.eclipse.birt.chart.device.util.CSSHelper;
import org.eclipse.birt.chart.device.util.HTMLEncoderAdapter;
import org.eclipse.birt.chart.device.util.ICharacterEncoderAdapter;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.MenuStylesKeyType;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.ScriptValue;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.MultipleActions;
import org.eclipse.emf.common.util.EMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiActionValuesScriptGenerator {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.device.extension/image");
    private static String MENU_JS_CODE;
    private static IScriptMenuHelper SCRIPT_MENU_HELPER;

    static {
        SCRIPT_MENU_HELPER = ScriptMenuHelper.instance();
    }

    public static String getJSContent(ActionValue values) {
        StringBuilder sb = MultiActionValuesScriptGenerator.getJSContext(values);
        sb.append("var popMenu = BirtChartMenuHelper.createPopupMenu(evt, menuInfo);\n");
        sb.append("if ( popMenu && popMenu != null ) popMenu.show();\n");
        return sb.toString();
    }

    public static String getJSContent(MultipleActions actions, ULocale locale) {
        StringBuilder sb = MultiActionValuesScriptGenerator.getJSContext(actions, locale);
        sb.append("if ( menuInfo.menuItemNames.length == 1 ) {\n");
        sb.append("\tBirtChartMenuHelper.executeMenuAction( evt, menuInfo.menuItems[0], menuInfo );\n");
        sb.append("} else { \n");
        sb.append("\tvar popMenu = BirtChartMenuHelper.createPopupMenu(evt, menuInfo);\n");
        sb.append("\tif ( popMenu && popMenu != null ) popMenu.show();\n");
        sb.append("}");
        return sb.toString();
    }

    public static String getJSKey(ActionValue values) {
        return MultiActionValuesScriptGenerator.getJSContext(values).toString();
    }

    public static String getJSKey(MultipleActions actions, ULocale locale) {
        return MultiActionValuesScriptGenerator.getJSContext(actions, locale).toString();
    }

    private static StringBuilder getJSContext(ActionValue values) {
        StringBuilder sb = new StringBuilder();
        if (values instanceof MultiURLValues) {
            MultiURLValues muv = (MultiURLValues)values;
            sb.append("\n\t var menuInfo = new BirtChartMenuInfo();\n");
            EMap<String, String> propMap = muv.getPropertiesMap();
            sb.append(MultiActionValuesScriptGenerator.getPropertiesJS(propMap).toString());
            int i = 0;
            for (URLValue uv : MultiActionValuesScriptGenerator.getValidURLValues(muv)) {
                sb = MultiActionValuesScriptGenerator.getURLValueJS(sb, i, uv, HTMLEncoderAdapter.getInstance());
                ++i;
            }
        }
        MultiActionValuesScriptGenerator.appendInteractivityVariables(sb);
        return sb;
    }

    public static StringBuilder appendInteractivityVariables(StringBuilder sb) {
        sb.append("\t if ( typeof categoryData != 'undefined' ) menuInfo.categoryData = categoryData;\n");
        sb.append("\t if ( typeof valueData != 'undefined' ) menuInfo.valueData = valueData;\n");
        sb.append("\t if ( typeof valueSeriesName != 'undefined' ) menuInfo.valueSeriesName = valueSeriesName;\n");
        sb.append("\t if ( typeof legendItemText != 'undefined' ) menuInfo.legendItemText = legendItemText;\n");
        sb.append("\t if ( typeof legendItemValue != 'undefined' ) menuInfo.legendItemValue = legendItemValue;\n");
        sb.append("\t if ( typeof axisLabel != 'undefined' ) menuInfo.axisLabel = axisLabel;\n");
        sb.append("\t if ( typeof id != 'undefined' ) menuInfo.id2 = id;\n");
        sb.append("\t if ( typeof compList != 'undefined' ) menuInfo.compList = compList;\n");
        sb.append("\t if ( typeof labelList != 'undefined' ) menuInfo.labelList = labelList;\n");
        sb.append("\t menuInfo.id = " + sb.toString().hashCode() + ";\n");
        return sb;
    }

    private static StringBuilder getJSContext(MultipleActions actions, ULocale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t var menuInfo = new BirtChartMenuInfo();\n");
        EMap<String, String> propMap = actions.getPropertiesMap();
        sb.append(MultiActionValuesScriptGenerator.getPropertiesJS(propMap).toString());
        int i = 0;
        for (Action subAction : MultiActionValuesScriptGenerator.getValidActions(actions)) {
            ActionValue av = subAction.getValue();
            if (av instanceof URLValue) {
                sb = MultiActionValuesScriptGenerator.getURLValueJS(sb, i, (URLValue)av, HTMLEncoderAdapter.getInstance());
            } else if (av instanceof ScriptValue) {
                sb = MultiActionValuesScriptGenerator.getScriptValueJS(sb, i, (ScriptValue)av, locale);
            }
            ++i;
        }
        MultiActionValuesScriptGenerator.appendInteractivityVariables(sb);
        return sb;
    }

    public static StringBuilder getScriptValueJS(StringBuilder sb, int index, ScriptValue sv, ULocale locale) {
        if (index == 0) {
            sb.append("\t var mii = new BirtChartMenuItemInfo();\n");
        } else {
            sb.append("\t mii = new BirtChartMenuItemInfo();\n");
        }
        sb.append(SCRIPT_MENU_HELPER.getScriptValueJS(index, sv, locale));
        return sb;
    }

    public static StringBuilder getVisualJS(StringBuilder sb, int index, ActionValue av, String scriptActionType) {
        if (index == 0) {
            sb.append("\t var mii = new BirtChartMenuItemInfo();");
        } else {
            sb.append("\t mii = new BirtChartMenuItemInfo();");
        }
        String text = av.getLabel().getCaption().getValue();
        if (av instanceof TooltipValue) {
            text = ((TooltipValue)av).getText();
        }
        sb.append("\t mii.text = '" + text + "';\n");
        sb.append("\t mii.actionType = " + scriptActionType + ";\n");
        sb.append("\t menuInfo.addItemInfo(mii);\n");
        return sb;
    }

    public static StringBuilder getURLValueJS(StringBuilder sb, int index, URLValue uv, ICharacterEncoderAdapter transferAdapter) {
        if (index == 0) {
            sb.append("\t var mii = new BirtChartMenuItemInfo();\n");
        } else {
            sb.append("\t mii = new BirtChartMenuItemInfo();\n");
        }
        String text = transferAdapter.transformToJsConstants(transferAdapter.escape(uv.getLabel().getCaption().getValue()));
        sb.append("\t mii.text = '" + text + "';\n");
        String url = uv.getBaseUrl();
        if (!url.startsWith("\"") && !url.endsWith("\"")) {
            url = "\"" + url + "\"";
        }
        sb.append("\t mii.actionType = BirtChartInteractivityActions.HYPER_LINK;\n");
        sb.append("\t mii.actionValue = " + url + ";\n");
        String target = uv.getTarget() == null ? "" : uv.getTarget();
        sb.append("\t mii.target = '" + target + "';\n");
        if (uv.getTooltip() != null && uv.getTooltip().trim().length() > 0) {
            String tooltip = transferAdapter.transformToJsConstants(uv.getTooltip());
            if (tooltip.startsWith("\"") || tooltip.startsWith("'")) {
                sb.append("\t mii.tooltip = " + tooltip + ";\n");
            } else {
                sb.append("\t mii.tooltip = '" + tooltip + "';\n");
            }
        }
        sb.append("\t menuInfo.addItemInfo(mii);\n");
        return sb;
    }

    private static StringBuilder getPropertiesJS(EMap<String, String> propMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : propMap.entrySet()) {
            String key = (String)entry.getKey();
            String properties = (String)entry.getValue();
            if (MenuStylesKeyType.MENU.getName().equals(key)) {
                if (!properties.matches(".*position[ ]*:.*")) {
                    properties = String.valueOf(properties) + ";position:absolute";
                }
                sb.append("\t menuInfo.menuStyles = '" + CSSHelper.getStylingNonHyphenFormat(properties) + "';\n");
                continue;
            }
            if (MenuStylesKeyType.MENU_ITEM.getName().equals(key)) {
                if (!properties.matches(".*cursor[ ]*:.*")) {
                    properties = String.valueOf(properties) + ";cursor:default";
                }
                sb.append("\t menuInfo.menuItemStyles = '" + CSSHelper.getStylingNonHyphenFormat(properties) + "';\n");
                continue;
            }
            if (MenuStylesKeyType.ON_MOUSE_OVER.getName().equals(key)) {
                sb.append("\t menuInfo.mouseOverStyles = '" + CSSHelper.getStylingNonHyphenFormat(properties) + "';\n");
                continue;
            }
            if (!MenuStylesKeyType.ON_MOUSE_OUT.getName().equals(key)) continue;
            sb.append("\tmenuInfo.mouseOutStyles = '" + CSSHelper.getStylingNonHyphenFormat(properties) + "';\n");
        }
        return sb;
    }

    public static List<URLValue> getValidURLValues(MultiURLValues multiUrlValue) {
        ArrayList<URLValue> validURLValues = new ArrayList<URLValue>();
        if (multiUrlValue == null) {
            return validURLValues;
        }
        for (URLValue uv : multiUrlValue.getURLValues()) {
            if (!MultiActionValuesScriptGenerator.isValidURLValue(uv)) continue;
            validURLValues.add(uv);
        }
        return validURLValues;
    }

    private static boolean isValidURLValue(URLValue uv) {
        return uv.getBaseUrl() != null && uv.getBaseUrl().length() > 0 && !uv.getBaseUrl().equals("\"\"");
    }

    public static boolean containsRedirection(Action action) {
        if (action instanceof MultipleActions) {
            return MultiActionValuesScriptGenerator.getValidActions((MultipleActions)action).size() > 0;
        }
        if (action.getType().getValue() == 0) {
            ActionValue av = action.getValue();
            if (av instanceof URLValue) {
                return MultiActionValuesScriptGenerator.isValidURLValue((URLValue)av);
            }
            if (av instanceof MultiURLValues) {
                return MultiActionValuesScriptGenerator.getValidURLValues((MultiURLValues)av).size() > 0;
            }
        }
        return false;
    }

    public static List<Action> getValidActions(MultipleActions multiActions) {
        ArrayList<Action> validActions = new ArrayList<Action>();
        if (multiActions == null) {
            return validActions;
        }
        for (Action subAction : multiActions.getActions()) {
            ScriptValue sv;
            URLValue uv;
            ActionValue av = subAction.getValue();
            if (av instanceof URLValue ? !MultiActionValuesScriptGenerator.isValidURLValue(uv = (URLValue)av) : av instanceof ScriptValue && !MultiActionValuesScriptGenerator.isValidScripts(sv = (ScriptValue)av)) continue;
            validActions.add(subAction);
        }
        return validActions;
    }

    private static boolean isValidScripts(ScriptValue sv) {
        return sv.getScript() != null && sv.getScript().length() != 0 && !sv.getScript().equals("\"\"");
    }

    public static String getBirtChartMenuLib() {
        if (MENU_JS_CODE == null) {
            StringBuilder sb = new StringBuilder();
            try {
                InputStream is = MultiActionValuesScriptGenerator.class.getResourceAsStream("/org/eclipse/birt/chart/device/util/ImageActionMenu.js");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String s = null;
                while ((s = br.readLine()) != null) {
                    sb.append(s);
                    sb.append("\n");
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                logger.log(e);
            }
            catch (IOException e) {
                logger.log(e);
            }
            MENU_JS_CODE = sb.toString();
        }
        return MENU_JS_CODE;
    }
}

