/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class AggregationResultSetWithOneMoreDummyAggr
implements IAggregationResultSet {
    private static Logger logger = Logger.getLogger(AggregationResultSetWithOneMoreDummyAggr.class.getName());
    private IAggregationResultSet ars;
    private String addedAggrName;
    private IBaseExpression addedAggrExpression;
    private Scriptable scope;
    private ScriptContext cx;

    public AggregationResultSetWithOneMoreDummyAggr(IAggregationResultSet aggregationResultSet, String addedAggrName, IBaseExpression addedAggrExpression, Scriptable scope, ScriptContext cx) {
        this.ars = aggregationResultSet;
        this.addedAggrName = addedAggrName;
        this.addedAggrExpression = addedAggrExpression;
        this.scope = scope;
        this.cx = cx;
        this.scope.put("data", this.scope, (Object)new JSDataObject());
        this.scope.put("row", this.scope, (Object)new JSDataObject());
        this.scope.put("dimension", this.scope, (Object)new JSDimensionObject());
    }

    public void clear() throws IOException {
        this.ars.clear();
    }

    public void close() throws IOException {
        this.ars.close();
    }

    public int getAggregationCount() {
        return this.ars.getAggregationCount() + 1;
    }

    public int getAggregationDataType(int aggregationIndex) throws IOException {
        return this.getAggregationDataType()[aggregationIndex];
    }

    public int[] getAggregationDataType() {
        int[] types = new int[this.ars.getAggregationCount() + 1];
        System.arraycopy(this.ars.getAggregationDataType(), 0, types, 0, this.ars.getAggregationDataType().length);
        types[types.length - 1] = this.addedAggrExpression.getDataType();
        return types;
    }

    public AggregationDefinition getAggregationDefinition() {
        return this.ars.getAggregationDefinition();
    }

    public int getAggregationIndex(String name) throws IOException {
        int index = this.ars.getAggregationIndex(name);
        if (index < 0) {
            if (this.addedAggrName.equals(name)) {
                return this.getAggregationCount() - 1;
            }
            return -1;
        }
        return index;
    }

    public String getAggregationName(int index) {
        if (index == this.getAggregationCount() - 1) {
            return this.addedAggrName;
        }
        return this.ars.getAggregationName(index);
    }

    public Object getAggregationValue(int aggregationIndex) throws IOException {
        if (aggregationIndex == this.getAggregationCount() - 1) {
            try {
                return ScriptEvalUtil.evalExpr(this.addedAggrExpression, this.cx.newContext(this.scope), ScriptExpression.defaultID, 0);
            }
            catch (DataException e) {
                logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                throw new IOException(e.getLocalizedMessage());
            }
        }
        return this.ars.getAggregationValue(aggregationIndex);
    }

    public DimLevel[] getAllLevels() {
        return this.ars.getAllLevels();
    }

    public String[][] getAttributeNames() {
        return this.ars.getAttributeNames();
    }

    public IAggregationResultRow getCurrentRow() throws IOException {
        IAggregationResultRow arr = this.ars.getCurrentRow();
        Object[] values1 = arr.getAggregationValues();
        Object[] values = new Object[values1.length + 1];
        System.arraycopy(values1, 0, values, 0, values1.length);
        values[values.length - 1] = this.getAggregationValue(this.getAggregationCount() - 1);
        AggregationResultRow result = new AggregationResultRow();
        result.setLevelMembers(arr.getLevelMembers());
        result.setAggregationValues(values);
        return result;
    }

    public String[][] getKeyNames() {
        return this.ars.getKeyNames();
    }

    public DimLevel getLevel(int levelIndex) {
        return this.ars.getLevel(levelIndex);
    }

    public Object getLevelAttribute(int levelIndex, int attributeIndex) {
        return this.ars.getLevelAttribute(levelIndex, attributeIndex);
    }

    public int getLevelAttributeColCount(int levelIndex) {
        return this.ars.getLevelAttributeColCount(levelIndex);
    }

    public int getLevelAttributeDataType(DimLevel level, String attributeName) {
        return this.ars.getLevelAttributeDataType(level, attributeName);
    }

    public int getLevelAttributeDataType(int levelIndex, String attributeName) {
        return this.ars.getLevelAttributeDataType(levelIndex, attributeName);
    }

    public int[][] getLevelAttributeDataType() {
        return this.ars.getLevelAttributeDataType();
    }

    public int getLevelAttributeIndex(int levelIndex, String attributeName) {
        return this.ars.getLevelAttributeIndex(levelIndex, attributeName);
    }

    public int getLevelAttributeIndex(DimLevel level, String attributeName) {
        return this.ars.getLevelAttributeIndex(level, attributeName);
    }

    public String[] getLevelAttributes(int levelIndex) {
        return this.ars.getLevelAttributes(levelIndex);
    }

    public String[][] getLevelAttributes() {
        return this.ars.getLevelAttributes();
    }

    public int getLevelCount() {
        return this.ars.getLevelCount();
    }

    public int getLevelIndex(DimLevel level) {
        return this.ars.getLevelIndex(level);
    }

    public int getLevelKeyColCount(int levelIndex) {
        return this.ars.getLevelKeyColCount(levelIndex);
    }

    public int getLevelKeyDataType(DimLevel level, String keyName) {
        return this.ars.getLevelKeyDataType(level, keyName);
    }

    public int getLevelKeyDataType(int levelIndex, String keyName) {
        return this.ars.getLevelKeyDataType(levelIndex, keyName);
    }

    public int[][] getLevelKeyDataType() {
        return this.ars.getLevelKeyDataType();
    }

    public int getLevelKeyIndex(int levelIndex, String keyName) {
        return this.ars.getLevelKeyIndex(levelIndex, keyName);
    }

    public int getLevelKeyIndex(DimLevel level, String keyName) {
        return this.ars.getLevelKeyIndex(level, keyName);
    }

    public String getLevelKeyName(int levelIndex, int keyIndex) {
        return this.ars.getLevelKeyName(levelIndex, keyIndex);
    }

    public Object[] getLevelKeyValue(int levelIndex) {
        return this.ars.getLevelKeyValue(levelIndex);
    }

    public String[][] getLevelKeys() {
        return this.ars.getLevelKeys();
    }

    public int getPosition() {
        return this.ars.getPosition();
    }

    public int getSortType(int levelIndex) {
        return this.ars.getSortType(levelIndex);
    }

    public int[] getSortType() {
        return this.ars.getSortType();
    }

    public int length() {
        return this.ars.length();
    }

    public void seek(int index) throws IOException {
        this.ars.seek(index);
    }

    public Object[] getLevelAttributesValue(int levelIndex) {
        return this.ars.getLevelAttributesValue(levelIndex);
    }

    private class JSDataObject
    extends ScriptableObject {
        private JSDataObject() {
        }

        public Object get(String arg0, Scriptable scope) {
            try {
                int index = AggregationResultSetWithOneMoreDummyAggr.this.ars.getAggregationIndex(arg0);
                if (index < 0) {
                    throw Context.reportRuntimeError((String)"data.olap.InvalidNestAggregationExpression");
                }
                return AggregationResultSetWithOneMoreDummyAggr.this.ars.getAggregationValue(index);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
                throw Context.reportRuntimeError((String)e.getLocalizedMessage());
            }
        }

        public String getClassName() {
            return JSDataObject.class.getName();
        }
    }

    private class JSDimensionObject
    extends ScriptableObject {
        private JSDimensionObject() {
        }

        public Object get(String name, Scriptable start) {
            return new JSLevelObject(name);
        }

        public String getClassName() {
            return JSDimensionObject.class.getName();
        }
    }

    private class JSLevelObject
    extends ScriptableObject {
        private String dimensionName;

        public JSLevelObject(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public Object get(String name, Scriptable start) {
            int levelIndex = AggregationResultSetWithOneMoreDummyAggr.this.ars.getLevelIndex(new DimLevel(this.dimensionName, name));
            if (levelIndex < 0) {
                throw Context.reportRuntimeError((String)"data.olap.InvalidNestAggregationExpression");
            }
            return new JSMemberObject(levelIndex);
        }

        public String getClassName() {
            return JSLevelObject.class.getName();
        }
    }

    private class JSMemberObject
    extends ScriptableObject {
        private int levelIndex;

        public JSMemberObject(int levelIndex) {
            this.levelIndex = levelIndex;
        }

        public Object getDefaultValue(Class typeHint) {
            return AggregationResultSetWithOneMoreDummyAggr.this.ars.getLevelKeyValue(this.levelIndex)[0];
        }

        public Object get(String name, Scriptable start) {
            int keyIndex = AggregationResultSetWithOneMoreDummyAggr.this.ars.getLevelKeyIndex(this.levelIndex, name);
            if (keyIndex >= 0) {
                return AggregationResultSetWithOneMoreDummyAggr.this.ars.getLevelKeyValue(this.levelIndex)[keyIndex];
            }
            int attrIndex = AggregationResultSetWithOneMoreDummyAggr.this.ars.getLevelAttributeIndex(keyIndex, name);
            if (attrIndex < 0) {
                throw Context.reportRuntimeError((String)"data.olap.InvalidNestAggregationExpression");
            }
            return AggregationResultSetWithOneMoreDummyAggr.this.ars.getLevelAttribute(this.levelIndex, attrIndex);
        }

        public String getClassName() {
            return JSMemberObject.class.getName();
        }
    }
}

