/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.index.v2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeFile;
import org.eclipse.birt.core.btree.BTreeOption;
import org.eclipse.birt.core.btree.BTreeSerializer;
import org.eclipse.birt.report.engine.content.impl.BookmarkContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTreeMap
extends BTree<String, Object> {
    static final int LONG_VALUE = 1;
    static final int BOOKMARK_VALUE = 2;
    int indexVersion = 0;
    int indexType = 2;

    public static BTreeMap openTreeMap(IDocArchiveReader archive, String name, int valueType) throws IOException {
        BTreeOption<String, Object> option = new BTreeOption<String, Object>();
        option.setReadOnly(true);
        option.setKeySerializer(new StringSerializer());
        option.setHasValue(true);
        option.setAllowDuplicate(false);
        option.setValueSerializer(new ObjectSerializer(valueType));
        option.setFile(new ArchiveInputFile(archive, name));
        return new BTreeMap(option);
    }

    public static BTreeMap createTreeMap(IDocArchiveWriter archive, String name, int valueType) throws IOException {
        BTreeOption<String, Object> option = new BTreeOption<String, Object>();
        option.setKeySerializer(new StringSerializer());
        option.setHasValue(true);
        option.setAllowDuplicate(false);
        option.setValueSerializer(new ObjectSerializer(valueType));
        option.setFile(new ArchiveOutputFile(archive, name));
        return new BTreeMap(option);
    }

    private BTreeMap(BTreeOption<String, Object> option) throws IOException {
        super(option);
    }

    @Override
    protected void readTreeHead(DataInput in) throws IOException {
        this.indexVersion = in.readInt();
        this.indexType = in.readInt();
        super.readTreeHead(in);
    }

    @Override
    protected void writeTreeHead(DataOutput out) throws IOException {
        out.writeInt(this.indexVersion);
        out.writeInt(this.indexType);
        super.writeTreeHead(out);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private static class ArchiveInputFile
    implements BTreeFile {
        IDocArchiveReader archive;
        String name;
        RAInputStream input;

        ArchiveInputFile(IDocArchiveReader archive, String name) throws IOException {
            this.archive = archive;
            this.name = name;
            this.input = archive.getInputStream(name);
        }

        public int allocBlock() throws IOException {
            throw new IOException("read only stream");
        }

        public int getTotalBlock() throws IOException {
            return (int)((this.input.length() + 4096L - 1L) / 4096L);
        }

        public Object lock() throws IOException {
            return this.archive.lock(this.name);
        }

        public void readBlock(int blockId, byte[] bytes) throws IOException {
            this.input.seek((long)blockId * 4096L);
            this.input.read(bytes);
        }

        public void unlock(Object lock) throws IOException {
            this.archive.unlock(lock);
        }

        public void writeBlock(int blockId, byte[] bytes) throws IOException {
            throw new IOException("read only stream");
        }

        public void close() throws IOException {
            this.input.close();
        }
    }

    private static class ArchiveOutputFile
    implements BTreeFile {
        IDocArchiveWriter archive;
        String name;
        RAOutputStream output;
        RAInputStream input;
        int totalBlock;

        ArchiveOutputFile(IDocArchiveWriter archive, String name) throws IOException {
            this.archive = archive;
            this.name = name;
            this.output = archive.createOutputStream(name);
            this.input = archive.getInputStream(name);
            this.totalBlock = 0;
        }

        public void close() throws IOException {
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
        }

        public int allocBlock() throws IOException {
            return this.totalBlock++;
        }

        public int getTotalBlock() throws IOException {
            return this.totalBlock;
        }

        public Object lock() throws IOException {
            return this.archive.lock(this.name);
        }

        public void readBlock(int blockId, byte[] bytes) throws IOException {
            this.input.refresh();
            this.input.seek((long)blockId * 4096L);
            this.input.read(bytes);
        }

        public void unlock(Object lock) throws IOException {
            this.archive.unlock(lock);
        }

        public void writeBlock(int blockId, byte[] bytes) throws IOException {
            if (blockId >= this.totalBlock) {
                this.totalBlock = blockId + 1;
            }
            this.output.seek((long)blockId * 4096L);
            this.output.write(bytes);
            this.output.flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectSerializer
    implements BTreeSerializer<Object> {
        int valueType;

        ObjectSerializer(int type) {
            this.valueType = type;
        }

        @Override
        public byte[] getBytes(Object object) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            DataOutputStream oo = new DataOutputStream(out);
            if (this.valueType == 1) {
                oo.writeLong((Long)object);
            } else if (this.valueType == 2) {
                ((BookmarkContent)object).writeStream(oo);
            }
            return out.toByteArray();
        }

        @Override
        public Object getObject(byte[] bytes) throws IOException, ClassNotFoundException {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
            if (this.valueType == 1) {
                return input.readLong();
            }
            if (this.valueType == 2) {
                BookmarkContent content = new BookmarkContent();
                content.readStream(input);
                return content;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringSerializer
    implements BTreeSerializer<String> {
        private StringSerializer() {
        }

        @Override
        public byte[] getBytes(String object) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            DataOutputStream oo = new DataOutputStream(out);
            oo.writeUTF(object);
            return out.toByteArray();
        }

        @Override
        public String getObject(byte[] bytes) throws IOException, ClassNotFoundException {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
            return input.readUTF();
        }
    }
}

