/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.writer;

import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.odf.IOdfMasterPageWriter;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.writer.AbstractOdfWriter;

public class MasterPageWriter
extends AbstractOdfWriter
implements IOdfMasterPageWriter {
    public static final Logger logger = Logger.getLogger(MasterPageWriter.class.getName());

    public MasterPageWriter(OutputStream out) {
        this(out, "UTF-8");
    }

    public MasterPageWriter(OutputStream out, String encoding) {
        this.writer = new XMLWriter();
        this.writer.setIndent(false);
        this.writer.open(out, encoding);
    }

    public MasterPageWriter(XMLWriter writer) {
        this.writer = writer;
    }

    public void start() {
        this.writer.openTag("office:master-styles");
    }

    public void end() {
        this.writer.closeTag("office:master-styles");
        try {
            this.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    public void startMasterPage(StyleEntry pageLayout, String masterPageName, String displayName) {
        this.writer.openTag("style:master-page");
        this.writer.attribute("style:name", masterPageName);
        if (displayName != null) {
            this.writer.attribute("style:display-name", displayName);
        }
        this.writer.attribute("style:page-layout-name", pageLayout.getName());
    }

    public void endMasterPage() {
        this.writer.closeTag("style:master-page");
    }

    public void startHeader() {
        this.writer.openTag("style:header");
    }

    public void endHeader() {
        this.writer.closeTag("style:header");
    }

    public void startFooter() {
        this.writer.openTag("style:footer");
    }

    public void endFooter() {
        this.writer.closeTag("style:footer");
    }
}

