/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class CrosstabSubTotalRowExecutor
extends BaseRowExecutor {
    private static Logger logger = Logger.getLogger(CrosstabSubTotalRowExecutor.class.getName());
    private int dimensionIndex;
    private int levelIndex;
    private boolean isLayoutDownThenOver;
    private int startTotalDimensionIndex;
    private int startTotalLevelIndex;
    private boolean rowEdgeStarted;
    private boolean rowSubTotalStarted;
    private int totalRowSpan;
    private boolean isFirstTotalRow;
    private boolean isSubTotalBefore;

    public CrosstabSubTotalRowExecutor(BaseCrosstabExecutor parent, int rowIndex, int dimensionIndex, int levelIndex) {
        super(parent, rowIndex);
        this.dimensionIndex = dimensionIndex;
        this.levelIndex = levelIndex;
    }

    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent(content, null);
        this.processRowHeight(this.findSubTotalRowCell(this.dimensionIndex, this.levelIndex, this.rowIndex));
        this.processRowLevelPageBreak(content, false);
        this.prepareChildren();
        return content;
    }

    protected void prepareChildren() {
        super.prepareChildren();
        this.initMeasureCache();
        this.isLayoutDownThenOver = "down then over".equals(this.crosstabItem.getPageLayout());
        if (this.isLayoutDownThenOver) {
            this.startTotalDimensionIndex = this.dimensionIndex;
            this.startTotalLevelIndex = this.levelIndex;
        } else {
            EdgeGroup nextGroup = GroupUtil.getNextGroup(this.rowGroups, this.dimensionIndex, this.levelIndex);
            this.startTotalDimensionIndex = nextGroup.dimensionIndex;
            this.startTotalLevelIndex = nextGroup.levelIndex;
        }
        DimensionViewHandle dv = this.crosstabItem.getDimension(0, this.dimensionIndex);
        LevelViewHandle lv = dv.getLevel(this.levelIndex);
        this.isSubTotalBefore = lv.getAggregationHeader() != null && "before".equals(lv.getAggregationHeaderLocation());
        this.isFirstTotalRow = this.rowIndex == GroupUtil.getFirstTotalRowIndex(this.crosstabItem, this.dimensionIndex, this.levelIndex, this.isVerticalMeasure);
        this.totalRowSpan = GroupUtil.getTotalRowSpan(this.crosstabItem, this.dimensionIndex, this.levelIndex, this.isVerticalMeasure);
        this.walker.reload();
    }

    private CrosstabCellHandle getSubTotalMeasureHeaderCell(int axis, int dimensionIndex, int levelIndex, int measureIndex) {
        if (measureIndex >= 0 && measureIndex < this.totalMeasureCount && dimensionIndex >= 0 && levelIndex >= 0) {
            DimensionViewHandle dv = this.crosstabItem.getDimension(axis, dimensionIndex);
            LevelViewHandle lv = dv.getLevel(levelIndex);
            return this.crosstabItem.getMeasure(measureIndex).getHeader(lv);
        }
        return null;
    }

    private AggregationCellHandle getRowSubTotalCell(int colDimensionIndex, int colLevelIndex, int measureIndex) {
        return this.getAggregationCell(this.dimensionIndex, this.levelIndex, colDimensionIndex, colLevelIndex, measureIndex);
    }

    private boolean isRowEdgeNeedStart(ColumnEvent ev) {
        if (this.rowEdgeStarted || ev.type != 1 || !this.isSubTotalBefore) {
            return false;
        }
        if (ev.dimensionIndex > this.dimensionIndex || ev.dimensionIndex == this.dimensionIndex && (this.isLayoutDownThenOver ? ev.levelIndex >= this.levelIndex : ev.levelIndex > this.levelIndex)) {
            return false;
        }
        if (ev.dimensionIndex != this.dimensionIndex || ev.levelIndex != this.levelIndex) {
            DimensionViewHandle dv = this.crosstabItem.getDimension(0, ev.dimensionIndex);
            LevelViewHandle lv = dv.getLevel(ev.levelIndex);
            if (!this.isLayoutDownThenOver && lv.getAggregationHeader() != null && "before".equals(lv.getAggregationHeaderLocation())) {
                return false;
            }
            int gdx = GroupUtil.getGroupIndex(this.rowGroups, ev.dimensionIndex, ev.levelIndex);
            if (gdx != -1) {
                try {
                    EdgeCursor rowEdgeCursor = this.getRowEdgeCursor();
                    if (rowEdgeCursor != null) {
                        DimensionCursor dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(gdx);
                        if (rowEdgeCursor.getPosition() != dc.getEdgeStart()) {
                            return false;
                        }
                    }
                }
                catch (OLAPException e) {
                    logger.log(Level.SEVERE, Messages.getString("CrosstabSubTotalRowExecutor.error.check.edge.start"), e);
                }
            }
        }
        return this.rowIndex == 0;
    }

    protected boolean checkMeasureVerticalSpanOverlapped(ColumnEvent ev) {
        if (ev.measureIndex == -1 && this.totalMeasureCount != 1) {
            return false;
        }
        int mx = ev.measureIndex;
        if (mx == -1) {
            mx = 0;
        }
        LevelHandle spanLevel = null;
        switch (ev.type) {
            case 2: 
            case 6: {
                spanLevel = this.getMeasureCell(mx).getSpanOverOnRow();
                break;
            }
            case 3: 
            case 4: {
                int dimCount = this.crosstabItem.getDimensionCount(0);
                DimensionViewHandle rdv = this.crosstabItem.getDimension(0, dimCount - 1);
                spanLevel = this.getAggregationCell(dimCount - 1, rdv.getLevelCount() - 1, ev.dimensionIndex, ev.levelIndex, mx).getSpanOverOnRow();
            }
        }
        if (spanLevel != null) {
            int targetRowSpanGroupIndex = GroupUtil.getGroupIndex(this.rowGroups, spanLevel);
            int currentGroupIndex = GroupUtil.getGroupIndex(this.rowGroups, this.dimensionIndex, this.levelIndex);
            if (targetRowSpanGroupIndex != -1) {
                return targetRowSpanGroupIndex <= currentGroupIndex;
            }
        }
        return false;
    }

    protected void advance() {
        int mx;
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: {
                        if (this.rowEdgeStarted) {
                            this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.lastDimensionIndex).getLevel(this.lastLevelIndex).getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                            ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                            this.rowEdgeStarted = false;
                            this.hasLast = false;
                            break;
                        }
                        if (!this.rowSubTotalStarted || ev.type == 1) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.dimensionIndex).getLevel(this.levelIndex).getAggregationHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.rowSubTotalStarted = false;
                        this.hasLast = false;
                        break;
                    }
                    case 5: {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.getSubTotalMeasureHeaderCell(0, this.dimensionIndex, this.levelIndex, this.rowIndex), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        int n = mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                        if (this.measureDetailStarted && this.isMeetMeasureDetailEnd(ev, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx))) {
                            this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                            ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                            this.measureDetailStarted = false;
                            this.hasLast = false;
                            break;
                        }
                        if (this.measureSubTotalStarted) {
                            this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                            ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                            this.measureSubTotalStarted = false;
                            this.hasLast = false;
                            break;
                        }
                        if (!this.measureGrandTotalStarted) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.measureGrandTotalStarted = false;
                        this.hasLast = false;
                    }
                }
                if (this.isRowEdgeNeedStart(ev)) {
                    this.rowEdgeStarted = true;
                    this.rowSpan = GroupUtil.computeRowSpan(this.crosstabItem, this.rowGroups, ev.dimensionIndex, ev.levelIndex, this.getRowEdgeCursor(), this.isLayoutDownThenOver);
                    this.colSpan = 0;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (!this.rowSubTotalStarted && ev.type == 1 && ev.dimensionIndex == this.startTotalDimensionIndex && ev.levelIndex == this.startTotalLevelIndex && this.isFirstTotalRow) {
                    this.rowSubTotalStarted = true;
                    this.rowSpan = this.totalRowSpan;
                    this.colSpan = 0;
                    this.hasLast = true;
                } else if (this.isMeasureDetailNeedStart(ev)) {
                    this.measureDetailStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    if (this.columnGroups != null && this.columnGroups.size() > 0) {
                        EdgeGroup gp = (EdgeGroup)this.columnGroups.get(this.columnGroups.size() - 1);
                        this.lastDimensionIndex = gp.dimensionIndex;
                        this.lastLevelIndex = gp.levelIndex;
                    } else {
                        this.lastDimensionIndex = ev.dimensionIndex;
                        this.lastLevelIndex = ev.levelIndex;
                    }
                    this.hasLast = true;
                } else if (this.isMeasureSubTotalNeedStart(ev)) {
                    this.measureSubTotalStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (this.isMeasureGrandTotalNeedStart(ev)) {
                    this.measureGrandTotalStarted = true;
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (ev.type == 5) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentChangeType = ev.type;
                this.currentEdgePosition = ev.dataPosition;
                ++this.colSpan;
                ++this.currentColIndex;
                if (this.nextExecutor == null) continue;
                return;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabSubTotalRowExecutor.error.retrieve.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            switch (this.currentChangeType) {
                case 1: {
                    if (this.rowEdgeStarted) {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.lastDimensionIndex).getLevel(this.lastLevelIndex).getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.rowEdgeStarted = false;
                        break;
                    }
                    if (!this.rowSubTotalStarted) break;
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.dimensionIndex).getLevel(this.levelIndex).getAggregationHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
                case 5: {
                    this.nextExecutor = new CrosstabCellExecutor(this, this.getSubTotalMeasureHeaderCell(0, this.dimensionIndex, this.levelIndex, this.rowIndex), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
            }
            if (this.measureDetailStarted) {
                mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.measureDetailStarted = false;
            } else if (this.measureSubTotalStarted) {
                mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.measureSubTotalStarted = false;
            } else if (this.measureGrandTotalStarted) {
                mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.measureGrandTotalStarted = false;
            }
        }
    }
}

