/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven;

import java.io.PrintStream;

public interface Logger {
    public void debug(CharSequence var1);

    public void debug(CharSequence var1, Throwable var2);

    public void debug(Throwable var1);

    public void info(CharSequence var1);

    public void info(CharSequence var1, Throwable var2);

    public void info(Throwable var1);

    public void warn(CharSequence var1);

    public void warn(CharSequence var1, Throwable var2);

    public void warn(Throwable var1);

    public void error(CharSequence var1);

    public void error(CharSequence var1, Throwable var2);

    public void error(Throwable var1);

    public static class SystemLogger
    implements Logger {
        private static final String ERROR = "[ERROR] ";
        private static final String WARNING = "[WARNING] ";
        private static final String DEBUG = "[DEBUG] ";
        private static final String INFO = "[INFO] ";
        private final boolean useSyserrForWarn;
        private final boolean useSyserrForErr;

        public SystemLogger(boolean useSyserrForWarn, boolean useSyserrForErr) {
            this.useSyserrForWarn = useSyserrForWarn;
            this.useSyserrForErr = useSyserrForErr;
        }

        @Override
        public void debug(CharSequence content) {
            System.out.println(DEBUG + content);
        }

        @Override
        public void debug(CharSequence content, Throwable error) {
            System.out.println(DEBUG + content);
            error.printStackTrace(System.out);
        }

        @Override
        public void debug(Throwable error) {
            System.out.println(DEBUG + error.getMessage());
            error.printStackTrace(System.out);
        }

        @Override
        public void info(CharSequence content) {
            System.out.println(INFO + content);
        }

        @Override
        public void info(CharSequence content, Throwable error) {
            System.out.println(INFO + content);
            error.printStackTrace(System.out);
        }

        @Override
        public void info(Throwable error) {
            System.out.println(INFO + error.getMessage());
            error.printStackTrace(System.out);
        }

        @Override
        public void warn(CharSequence content) {
            PrintStream out = this.useSyserrForWarn ? System.err : System.out;
            out.println(WARNING + content);
        }

        @Override
        public void warn(CharSequence content, Throwable error) {
            PrintStream out = this.useSyserrForWarn ? System.err : System.out;
            out.println(WARNING + content);
            error.printStackTrace(out);
        }

        @Override
        public void warn(Throwable error) {
            PrintStream out = this.useSyserrForWarn ? System.err : System.out;
            out.println(WARNING + error.getMessage());
            error.printStackTrace(out);
        }

        @Override
        public void error(CharSequence content) {
            PrintStream out = this.useSyserrForErr ? System.err : System.out;
            out.println(ERROR + content);
        }

        @Override
        public void error(CharSequence content, Throwable error) {
            PrintStream out = this.useSyserrForErr ? System.err : System.out;
            out.println(ERROR + content);
            error.printStackTrace(out);
        }

        @Override
        public void error(Throwable error) {
            PrintStream out = this.useSyserrForErr ? System.err : System.out;
            out.println(ERROR + error.getMessage());
            error.printStackTrace(out);
        }
    }
}

