/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.http.apache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.cbi.maven.Logger;
import org.eclipse.cbi.maven.http.CompletionListener;
import org.eclipse.cbi.maven.http.HttpClient;
import org.eclipse.cbi.maven.http.HttpRequest;
import org.eclipse.cbi.maven.http.apache.BasicHttpResult;
import org.eclipse.cbi.maven.http.apache.PathBody;

public class ApacheHttpClient
implements HttpClient {
    private final Logger log;

    ApacheHttpClient(Logger log) {
        this.log = Objects.requireNonNull(log);
    }

    public static HttpClient create(Logger log) {
        return new ApacheHttpClient(log);
    }

    @Override
    public boolean send(HttpRequest request, CompletionListener completionListener) throws IOException {
        return this.send(request, HttpRequest.Config.defaultConfig(), completionListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean send(HttpRequest request, HttpRequest.Config config, CompletionListener completionListener) throws IOException {
        Objects.requireNonNull(request);
        HttpUriRequest apacheRequest = ApacheHttpClient.toApacheRequest(request, config);
        this.log.debug("Will send HTTP request " + request);
        this.log.debug("HTTP request configuration is " + config);
        Stopwatch stopwatch = Stopwatch.createStarted();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try (CloseableHttpClient apacheHttpClient = HttpClientBuilder.create().build();){
            ResponseHandler responseHandler = response -> this.doHandleResponse(completionListener, response);
            Future<Boolean> requestExec = executor.submit(() -> (Boolean)apacheHttpClient.execute(apacheRequest, responseHandler));
            boolean ret = Duration.ZERO.equals(config.timeout()) ? requestExec.get().booleanValue() : requestExec.get(config.timeout().toMillis(), TimeUnit.MILLISECONDS).booleanValue();
            boolean bl = ret;
            return bl;
        }
        catch (InterruptedException e) {
            apacheRequest.abort();
            executor.shutdownNow();
            Thread.currentThread().interrupt();
            return false;
        }
        catch (TimeoutException e) {
            apacheRequest.abort();
            executor.shutdownNow();
            this.log.debug("HTTP request and response handled in " + stopwatch);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            apacheRequest.abort();
            executor.shutdownNow();
            this.log.debug("HTTP request and response handled in " + stopwatch);
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), IOException.class);
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    private Boolean doHandleResponse(CompletionListener completionListener, HttpResponse response) throws IOException {
        StatusLine statusLine = Objects.requireNonNull(response.getStatusLine(), "Can't retrieve status line of the HttpResponse");
        int statusCode = statusLine.getStatusCode();
        this.log.debug("HTTP status code = " + statusCode);
        this.log.debug("HTTP reason phrase = '" + statusLine.getReasonPhrase() + "'");
        HttpEntity entity = response.getEntity();
        boolean success = statusCode >= 200 && statusCode < 300 && entity != null;
        BasicHttpResult httpResult = new BasicHttpResult(statusCode, Strings.nullToEmpty((String)statusLine.getReasonPhrase()), entity);
        if (success) {
            completionListener.onSuccess(httpResult);
        } else {
            completionListener.onError(httpResult);
        }
        return success;
    }

    @VisibleForTesting
    static HttpUriRequest toApacheRequest(HttpRequest request, HttpRequest.Config config) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setStrictMode();
        for (Map.Entry<String, String> entry : request.stringParameters().entrySet()) {
            builder.addTextBody(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : request.pathParameters().entrySet()) {
            builder.addPart(entry.getKey(), (ContentBody)new PathBody((Path)entry.getValue()));
        }
        HttpPost post = new HttpPost(request.serverUri());
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)config.readTimeout().toMillis()).setSocketTimeout((int)config.readTimeout().toMillis()).setConnectTimeout((int)config.connectTimeout().toMillis()).build();
        post.setConfig(requestConfig);
        post.setEntity(builder.build());
        return post;
    }
}

