/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.http.apache;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.eclipse.cbi.maven.http.HttpResult;

final class BasicHttpResult
implements HttpResult {
    private final int status;
    private final String reason;
    private final HttpEntity entity;

    BasicHttpResult(int status, String reason, HttpEntity entity) {
        this.status = status;
        this.reason = (String)Preconditions.checkNotNull((Object)reason);
        this.entity = (HttpEntity)Preconditions.checkNotNull((Object)entity);
    }

    @Override
    public int statusCode() {
        return this.status;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public long contentLength() {
        return this.entity.getContentLength();
    }

    @Override
    public long copyContent(Path target, CopyOption ... options) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(this.entity.getContent());){
            long l = Files.copy(is, target, options);
            return l;
        }
    }

    @Override
    public long copyContent(OutputStream target) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(this.entity.getContent());){
            long l = ByteStreams.copy((InputStream)is, (OutputStream)target);
            return l;
        }
    }

    @Override
    public Charset contentCharset() {
        ContentType contentType = ContentType.get((HttpEntity)this.entity);
        Charset cs = contentType != null && contentType.getCharset() != null ? contentType.getCharset() : StandardCharsets.UTF_8;
        return cs;
    }
}

