/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.http.apache;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.util.Args;

final class PathBody
extends AbstractContentBody {
    private final Path path;

    PathBody(Path path) {
        super(ContentType.DEFAULT_BINARY);
        this.path = path;
    }

    public PathBody(Path path, String contentType) {
        super(ContentType.parse((String)contentType));
        this.path = path;
    }

    public String getFilename() {
        return this.path.getFileName().toString();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        Files.copy(this.path, outstream);
        outstream.flush();
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public long getContentLength() {
        try {
            return Files.size(this.path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

