/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.maven.plugins.jarsigner;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import org.eclipse.cbi.common.security.MessageDigestAlgorithm;
import org.eclipse.cbi.common.security.SignatureAlgorithm;
import org.eclipse.cbi.maven.plugins.jarsigner.AutoValue_JarSigner_Options;

public interface JarSigner {
    public int sign(Path var1, Options var2) throws IOException;

    public static abstract class Options {
        private static final Duration CONNECT_TIMEOUT__DEFAULT = Duration.ofSeconds(5L);
        private static final Duration TIMEOUT__DEFAULT = Duration.ZERO;
        private static final String SIGFILE__DEFAULT = "";

        public abstract MessageDigestAlgorithm digestAlgorithm();

        public abstract SignatureAlgorithm signatureAlgorithm();

        @Deprecated
        public abstract Duration connectTimeout();

        public abstract Duration timeout();

        public abstract String sigFile();

        public static Builder builder() {
            return new AutoValue_JarSigner_Options.Builder().signatureAlgorithm(SignatureAlgorithm.DEFAULT).digestAlgorithm(MessageDigestAlgorithm.DEFAULT).connectTimeout(CONNECT_TIMEOUT__DEFAULT).timeout(TIMEOUT__DEFAULT).sigFile(SIGFILE__DEFAULT);
        }

        public static Builder copy(Options option) {
            return Options.builder().digestAlgorithm(option.digestAlgorithm()).signatureAlgorithm(option.signatureAlgorithm()).connectTimeout(option.connectTimeout()).timeout(option.timeout()).sigFile(option.sigFile());
        }

        public static abstract class Builder {
            public abstract Builder digestAlgorithm(MessageDigestAlgorithm var1);

            public abstract Builder signatureAlgorithm(SignatureAlgorithm var1);

            @Deprecated
            public abstract Builder connectTimeout(Duration var1);

            public abstract Builder timeout(Duration var1);

            public abstract Builder sigFile(String var1);

            public abstract Options build();
        }
    }
}

