/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.map.sorted;

import java.util.SortedMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.ImmutableMapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.map.sorted.SortedMapIterable;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.multimap.sortedset.ImmutableSortedSetMultimap;
import org.eclipse.collections.api.partition.list.PartitionImmutableList;
import org.eclipse.collections.api.tuple.Pair;

public interface ImmutableSortedMap<K, V>
extends SortedMapIterable<K, V>,
ImmutableMapIterable<K, V> {
    @Override
    public SortedMap<K, V> castToMap();

    public SortedMap<K, V> castToSortedMap();

    @Override
    public ImmutableSortedSetMultimap<V, K> flip();

    @Override
    public ImmutableSortedMap<K, V> newWithKeyValue(K var1, V var2);

    @Override
    public ImmutableSortedMap<K, V> newWithAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> var1);

    @Override
    public ImmutableSortedMap<K, V> newWithAllKeyValueArguments(Pair<? extends K, ? extends V> ... var1);

    @Override
    public ImmutableSortedMap<K, V> newWithoutKey(K var1);

    @Override
    public ImmutableSortedMap<K, V> newWithoutAllKeys(Iterable<? extends K> var1);

    public MutableSortedMap<K, V> toSortedMap();

    @Override
    public ImmutableSortedMap<K, V> select(Predicate2<? super K, ? super V> var1);

    @Override
    public ImmutableSortedMap<K, V> reject(Predicate2<? super K, ? super V> var1);

    @Override
    public ImmutableSortedMap<K, V> tap(Procedure<? super V> var1);

    @Override
    public ImmutableList<V> select(Predicate<? super V> var1);

    @Override
    public <P> ImmutableList<V> selectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public ImmutableList<V> reject(Predicate<? super V> var1);

    @Override
    public <P> ImmutableList<V> rejectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public <S> ImmutableList<S> selectInstancesOf(Class<S> var1);

    @Override
    public PartitionImmutableList<V> partition(Predicate<? super V> var1);

    @Override
    public <P> PartitionImmutableList<V> partitionWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public <R> ImmutableList<R> collect(Function<? super V, ? extends R> var1);

    @Override
    default public <R> ImmutableList<R> collectWithIndex(ObjectIntToObjectFunction<? super V, ? extends R> function) {
        int[] index = new int[]{0};
        return this.collect((T each) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf((Object)each, n);
        });
    }

    @Override
    public <P, VV> ImmutableList<VV> collectWith(Function2<? super V, ? super P, ? extends VV> var1, P var2);

    @Override
    public <K2, V2> ImmutableMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> var1);

    @Override
    public <R> ImmutableSortedMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> var1);

    @Override
    public <R> ImmutableList<R> collectIf(Predicate<? super V> var1, Function<? super V, ? extends R> var2);

    @Override
    public <R> ImmutableList<R> flatCollect(Function<? super V, ? extends Iterable<R>> var1);

    @Override
    default public <P, R> ImmutableList<R> flatCollectWith(Function2<? super V, ? super P, ? extends Iterable<R>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    @Override
    public ImmutableBooleanList collectBoolean(BooleanFunction<? super V> var1);

    @Override
    public ImmutableByteList collectByte(ByteFunction<? super V> var1);

    @Override
    public ImmutableCharList collectChar(CharFunction<? super V> var1);

    @Override
    public ImmutableDoubleList collectDouble(DoubleFunction<? super V> var1);

    @Override
    public ImmutableFloatList collectFloat(FloatFunction<? super V> var1);

    @Override
    public ImmutableIntList collectInt(IntFunction<? super V> var1);

    @Override
    public ImmutableLongList collectLong(LongFunction<? super V> var1);

    @Override
    public ImmutableShortList collectShort(ShortFunction<? super V> var1);

    @Override
    public <S> ImmutableList<Pair<V, S>> zip(Iterable<S> var1);

    @Override
    public ImmutableList<Pair<V, Integer>> zipWithIndex();

    @Override
    public <VV> ImmutableListMultimap<VV, V> groupBy(Function<? super V, ? extends VV> var1);

    @Override
    public <VV> ImmutableListMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> var1);

    @Override
    default public <VV> ImmutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        MutableMap target = Maps.mutable.withInitialCapacity(this.size());
        return this.groupByUniqueKey(function, target).toImmutable();
    }

    @Override
    default public <KK, VV> ImmutableMap<KK, VV> aggregateInPlaceBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEach((? super T each) -> {
            Object key = groupBy.valueOf((Object)each);
            Function0 value = map.getIfAbsentPut(key, zeroValueFactory);
            mutatingAggregator.value((Object)value, (Object)each);
        });
        return map.toImmutable();
    }

    @Override
    default public <KK, VV> ImmutableMap<KK, VV> aggregateBy(Function<? super V, ? extends KK> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        MutableMap map = this.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator, Maps.mutable.empty());
        return map.toImmutable();
    }
}

