/*
 * Copyright (c) 2024 Goldman Sachs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.primitive;

import org.eclipse.collections.api.factory.ServiceLoaderUtils;
import org.eclipse.collections.api.factory.map.primitive.ImmutableIntCharMapFactory;
import org.eclipse.collections.api.factory.map.primitive.MutableIntCharMapFactory;

/**
 * IntCharMaps is a static utility for creating {@link ImmutableIntCharMapFactory}
 * and {@link MutableIntCharMapFactory}.
 * This file was automatically generated from template file primitivePrimitiveMapsAPI.stg.
 *
 * @since 11.1.
 */
@SuppressWarnings("ConstantNamingConvention")
@aQute.bnd.annotation.spi.ServiceConsumer(value = ImmutableIntCharMapFactory.class)
@aQute.bnd.annotation.spi.ServiceConsumer(value = MutableIntCharMapFactory.class)
public final class IntCharMaps
{
    public static final ImmutableIntCharMapFactory immutable =
            ServiceLoaderUtils.loadServiceClass(ImmutableIntCharMapFactory.class);
    public static final MutableIntCharMapFactory mutable =
            ServiceLoaderUtils.loadServiceClass(MutableIntCharMapFactory.class);

    private IntCharMaps()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
