/*
 * Copyright (c) 2024 Goldman Sachs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.primitive;

import org.eclipse.collections.api.factory.ServiceLoaderUtils;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableBooleanStackFactory;
import org.eclipse.collections.api.factory.stack.primitive.MutableBooleanStackFactory;

/**
 * BooleanStacks is a static utility for creating {@link ImmutableBooleanStackFactory} and {@link MutableBooleanStackFactory}.
 * This file was automatically generated from template file primitiveStacksAPI.stg.
 *
 * @since 11.1.
 */
@SuppressWarnings("ConstantNamingConvention")
@aQute.bnd.annotation.spi.ServiceConsumer(value = ImmutableBooleanStackFactory.class)
@aQute.bnd.annotation.spi.ServiceConsumer(value = MutableBooleanStackFactory.class)
public final class BooleanStacks
{
    public static final ImmutableBooleanStackFactory immutable =
            ServiceLoaderUtils.loadServiceClass(ImmutableBooleanStackFactory.class);
    public static final MutableBooleanStackFactory mutable =
            ServiceLoaderUtils.loadServiceClass(MutableBooleanStackFactory.class);

    private BooleanStacks()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
