/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.bag.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.collection.primitive.ImmutableCharCollection;

/**
 * This file was automatically generated from template file immutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface ImmutableCharBag extends ImmutableCharCollection, CharBag
{
    ImmutableCharBag select(CharPredicate predicate);

    ImmutableCharBag reject(CharPredicate predicate);

    <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function);

    ImmutableCharBag newWith(char element);

    ImmutableCharBag newWithout(char element);

    ImmutableCharBag newWithAll(CharIterable elements);

    ImmutableCharBag newWithoutAll(CharIterable elements);
}
