/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.set.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.set.MutableSet;

/**
 * This file was automatically generated from template file mutablePrimitiveSet.stg.
 *
 * @since 3.0.
 */
public interface MutableByteSet extends MutableByteCollection, ByteSet
{
    MutableByteSet select(BytePredicate predicate);

    MutableByteSet reject(BytePredicate predicate);

    <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function);

    MutableByteSet with(byte element);

    MutableByteSet without(byte element);

    MutableByteSet withAll(ByteIterable elements);

    MutableByteSet withoutAll(ByteIterable elements);

    MutableByteSet asUnmodifiable();

    MutableByteSet asSynchronized();

    /**
     * Returns a frozen copy of this set. A frozen copy is the same thing as an immutable copy without safe-publish guarantees.
     */
    ByteSet freeze();

    /**
     * Returns an immutable copy of this set.
     */
    ImmutableByteSet toImmutable();
}
