/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import java.io.Serializable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class GitObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    ObjectId sha1;
    String name;

    public GitObject(String name, ObjectId sha1) {
        this.name = name;
        this.sha1 = sha1;
    }

    public ObjectId getSHA1() {
        return this.sha1;
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported(name="SHA1")
    public String getSHA1String() {
        return this.sha1.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitObject gitObject = (GitObject)o;
        if (this.name != null ? !this.name.equals(gitObject.name) : gitObject.name != null) {
            return false;
        }
        return !(this.sha1 != null ? !this.sha1.equals((AnyObjectId)gitObject.sha1) : gitObject.sha1 != null);
    }

    public int hashCode() {
        int result = this.sha1 != null ? this.sha1.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

