/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GithubWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final URL url;

    @DataBoundConstructor
    public GithubWeb(String url) throws MalformedURLException {
        this.url = GithubWeb.normalizeToEndWithSlash((URL)new URL(url));
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.url, this.url.getPath() + "commit/" + changeSet.getId().toString());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        return this.getDiffLinkRegardlessOfEditType(path);
    }

    private URL getDiffLinkRegardlessOfEditType(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        ArrayList<String> affectedPaths = new ArrayList<String>(changeSet.getAffectedPaths());
        Collections.sort(affectedPaths);
        String pathAsString = path.getPath();
        int i = Collections.binarySearch(affectedPaths, pathAsString);
        assert (i >= 0);
        return new URL(this.getChangeSetLink(changeSet), "#diff-" + String.valueOf(i));
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLinkRegardlessOfEditType(path);
        }
        String spec = "blob/" + path.getChangeSet().getId() + "/" + path.getPath();
        return new URL(this.url, this.url.getPath() + spec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GithubWeb githubWeb = (GithubWeb)((Object)o);
        return !(this.url != null ? !this.url.equals(githubWeb.url) : githubWeb.url != null);
    }

    public int hashCode() {
        return this.url != null ? this.url.hashCode() : 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class GithubWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "githubweb";
        }

        public GithubWeb newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (GithubWeb)((Object)req.bindParameters(GithubWeb.class, "githubweb."));
        }

        public FormValidation doCheckUrl(@QueryParameter(fixEmpty=true) String url) throws IOException, ServletException {
            return new GitRepositoryBrowser.GitUrlChecker(url, "github").check();
        }
    }
}

