/*
 * Decompiled with CFR 0.152.
 */
package org.spearce.jgit.transport;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jgit.lib.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConfig
extends Config
implements Externalizable {
    private static final String KEY_URL = "url";
    private static final String KEY_FETCH = "fetch";
    private static final String KEY_PUSH = "push";
    private static final String KEY_UPLOAD_PACK = "uploadpack";
    private static final String KEY_RECEIVE_PACK = "receivepack";
    private static final String KEY_TAG_OPT = "tagopt";
    private String name;
    private String uploadpack = "git-upload-pack";
    private String receivepack = "git-receive-pack";
    private String tagopt;
    private List<String> uris = new ArrayList<String>();
    private List<String> fetch = new ArrayList<String>();
    private List<String> push = new ArrayList<String>();
    private final Map<String, String> stringsMap = new HashMap<String, String>();
    private final Map<String, List<String>> stringsListMap = new HashMap<String, List<String>>();

    public RemoteConfig() {
        this.stringsMap.put(KEY_RECEIVE_PACK, this.receivepack);
        this.stringsMap.put(KEY_UPLOAD_PACK, this.uploadpack);
        this.stringsMap.put(KEY_TAG_OPT, this.tagopt);
        this.stringsListMap.put(KEY_URL, this.uris);
        this.stringsListMap.put(KEY_FETCH, this.fetch);
        this.stringsListMap.put(KEY_PUSH, this.push);
    }

    public void setTagopt(String tagopt) {
        this.tagopt = tagopt;
        this.stringsMap.put(KEY_TAG_OPT, tagopt);
    }

    public void setReceivepack(String receivepack) {
        this.receivepack = receivepack;
        this.stringsMap.put(KEY_RECEIVE_PACK, receivepack);
    }

    public void setUploadpack(String uploadpack) {
        this.uploadpack = uploadpack;
        this.stringsMap.put(KEY_UPLOAD_PACK, uploadpack);
    }

    public void setFetch(List<String> fetch) {
        this.fetch = fetch;
        this.stringsListMap.put(KEY_FETCH, fetch);
    }

    public void setPush(List<String> push) {
        this.push = push;
        this.stringsListMap.put(KEY_PUSH, push);
    }

    public void setUris(List<String> uris) {
        this.uris = uris;
        this.stringsListMap.put(KEY_URL, uris);
    }

    public String getString(String section, String subsection, String name) {
        String result = this.stringsMap.get(name);
        if (null != result) {
            return result;
        }
        return super.getString(section, subsection, name);
    }

    public String[] getStringList(String section, String subsection, String name) {
        List<String> result = this.stringsListMap.get(name);
        if (null != result) {
            return result.toArray(new String[result.size()]);
        }
        return super.getStringList(section, subsection, name);
    }

    private void fromMap(Map<String, List<String>> map) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            if (!CollectionUtils.isNotEmpty(values)) continue;
            if (KEY_URL.equals(key)) {
                this.setUris(values);
                continue;
            }
            if (KEY_FETCH.equals(key)) {
                this.setFetch(values);
                continue;
            }
            if (KEY_PUSH.equals(key)) {
                this.setPush(values);
                continue;
            }
            if (KEY_UPLOAD_PACK.equals(key)) {
                this.setUploadpack(values.get(0));
                continue;
            }
            if (KEY_RECEIVE_PACK.equals(key)) {
                this.setReceivepack(values.get(0));
                continue;
            }
            if (!KEY_TAG_OPT.equals(key)) continue;
            this.setTagopt(values.get(0));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        int items = in.readInt();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (int i = 0; i < items; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            ArrayList<String> values = (ArrayList<String>)map.get(key);
            if (null == values) {
                values = new ArrayList<String>();
                map.put(key, values);
            }
            values.add(value);
        }
        this.fromMap(map);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IOException("writeExternal not supported");
    }

    public org.eclipse.jgit.transport.RemoteConfig toRemote() throws URISyntaxException {
        return new org.eclipse.jgit.transport.RemoteConfig((Config)this, this.name);
    }
}

