/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class JavaElementProvider
implements IInformationProvider,
IInformationProviderExtension {
    private JavaEditor fEditor;
    private boolean fUseCodeResolve = false;

    public JavaElementProvider(IEditorPart editor) {
        if (editor instanceof JavaEditor) {
            this.fEditor = (JavaEditor)editor;
        }
    }

    public JavaElementProvider(IEditorPart editor, boolean useCodeResolve) {
        this(editor);
        this.fUseCodeResolve = useCodeResolve;
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null && this.fEditor != null) {
            IRegion region = JavaWordFinder.findWord(textViewer.getDocument(), offset);
            if (region != null) {
                return region;
            }
            return new Region(offset, 0);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        return this.getInformation2(textViewer, subject).toString();
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        if (this.fEditor == null) {
            return null;
        }
        try {
            IStructuredSelection sel;
            if (this.fUseCodeResolve && !(sel = SelectionConverter.getStructuredSelection((IWorkbenchPart)this.fEditor)).isEmpty()) {
                return sel.getFirstElement();
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor, false);
            if (element != null) {
                return element;
            }
            return EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }
}

