/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.transport.internal;

import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpConnectionOverFCGI;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Promise;

public class HttpReceiverOverFCGI
extends HttpReceiver {
    private Content.Chunk chunk;

    public HttpReceiverOverFCGI(HttpChannel channel) {
        super(channel);
    }

    void receive() {
        if (!this.hasContent()) {
            HttpConnectionOverFCGI httpConnection = this.getHttpChannel().getHttpConnection();
            boolean setFillInterest = httpConnection.parseAndFill();
            if (!this.hasContent() && setFillInterest) {
                httpConnection.fillInterested();
            }
        } else {
            this.responseContentAvailable();
        }
    }

    public void onInterim() {
        this.receive();
    }

    protected void reset() {
        super.reset();
        if (this.chunk != null) {
            this.chunk.release();
            this.chunk = null;
        }
    }

    protected void dispose() {
        super.dispose();
        if (this.chunk != null) {
            this.chunk.release();
            this.chunk = null;
        }
    }

    public Content.Chunk read(boolean fillInterestIfNeeded) {
        Content.Chunk chunk = this.consumeChunk();
        if (chunk != null) {
            return chunk;
        }
        HttpConnectionOverFCGI httpConnection = this.getHttpChannel().getHttpConnection();
        boolean needFillInterest = httpConnection.parseAndFill();
        chunk = this.consumeChunk();
        if (chunk != null) {
            return chunk;
        }
        if (needFillInterest && fillInterestIfNeeded) {
            httpConnection.fillInterested();
        }
        return null;
    }

    private Content.Chunk consumeChunk() {
        Content.Chunk chunk = this.chunk;
        this.chunk = null;
        return chunk;
    }

    public void failAndClose(Throwable failure) {
        this.responseFailure(failure, (Promise<Boolean>)Promise.from(failed -> {
            if (failed.booleanValue()) {
                this.getHttpChannel().getHttpConnection().close(failure);
            }
        }, x -> this.getHttpChannel().getHttpConnection().close(failure)));
    }

    void content(Content.Chunk chunk) {
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        chunk.retain();
        this.chunk = chunk;
        this.responseContentAvailable();
    }

    void end(HttpExchange exchange) {
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        this.chunk = Content.Chunk.EOF;
        this.responseSuccess(exchange, this::receiveNext);
    }

    private void receiveNext() {
        if (this.hasContent()) {
            throw new IllegalStateException();
        }
        if (this.chunk != null) {
            throw new IllegalStateException();
        }
        HttpConnectionOverFCGI httpConnection = this.getHttpChannel().getHttpConnection();
        boolean setFillInterest = httpConnection.parseAndFill();
        if (!this.hasContent() && setFillInterest) {
            httpConnection.fillInterested();
        }
    }

    protected HttpChannelOverFCGI getHttpChannel() {
        return (HttpChannelOverFCGI)super.getHttpChannel();
    }

    protected void responseBegin(HttpExchange exchange) {
        super.responseBegin(exchange);
    }

    protected void responseHeader(HttpExchange exchange, HttpField field) {
        super.responseHeader(exchange, field);
    }

    protected void responseHeaders(HttpExchange exchange) {
        super.responseHeaders(exchange);
    }

    protected void responseFailure(Throwable failure, Promise<Boolean> promise) {
        super.responseFailure(failure, promise);
    }
}

