/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.fcgi.parser.ServerParser;
import org.eclipse.jetty.util.NanoTime;

public class BeginRequestContentParser
extends ContentParser {
    private final ServerParser.Listener listener;
    private State state = State.ROLE;
    private int cursor;
    private int role;
    private int flags;
    private long beginNanoTime;

    public BeginRequestContentParser(HeaderParser headerParser, ServerParser.Listener listener) {
        super(headerParser);
        this.listener = listener;
    }

    public long getBeginNanoTime() {
        return this.beginNanoTime;
    }

    @Override
    public ContentParser.Result parse(ByteBuffer buffer) {
        block7: while (buffer.hasRemaining()) {
            switch (this.state.ordinal()) {
                case 0: {
                    this.beginNanoTime = NanoTime.now();
                    if (buffer.remaining() >= 2) {
                        this.role = buffer.getShort();
                        this.state = State.FLAGS;
                        continue block7;
                    }
                    this.state = State.ROLE_BYTES;
                    this.cursor = 0;
                    continue block7;
                }
                case 1: {
                    int halfShort = buffer.get() & 0xFF;
                    this.role = (this.role << 8) + halfShort;
                    if (++this.cursor != 2) continue block7;
                    this.state = State.FLAGS;
                    continue block7;
                }
                case 2: {
                    this.flags = buffer.get() & 0xFF;
                    this.state = State.RESERVED;
                    continue block7;
                }
                case 3: {
                    if (buffer.remaining() >= 5) {
                        buffer.position(buffer.position() + 5);
                        this.onStart();
                        this.reset();
                        return ContentParser.Result.COMPLETE;
                    }
                    this.state = State.RESERVED_BYTES;
                    this.cursor = 0;
                    continue block7;
                }
                case 4: {
                    buffer.get();
                    if (++this.cursor != 5) continue block7;
                    this.onStart();
                    this.reset();
                    return ContentParser.Result.COMPLETE;
                }
            }
            throw new IllegalStateException();
        }
        return ContentParser.Result.PENDING;
    }

    private void onStart() {
        this.listener.onStart(this.getRequest(), FCGI.Role.from(this.role), this.flags);
    }

    private void reset() {
        this.state = State.ROLE;
        this.cursor = 0;
        this.role = 0;
        this.flags = 0;
    }

    private static enum State {
        ROLE,
        ROLE_BYTES,
        FLAGS,
        RESERVED,
        RESERVED_BYTES;

    }
}

