/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.transport.internal;

import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.HTTP2StreamEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHTTP2StreamEndPoint
extends HTTP2StreamEndPoint
implements HTTP2Channel.Client {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHTTP2StreamEndPoint.class);

    public ClientHTTP2StreamEndPoint(HTTP2Stream stream) {
        super(stream);
    }

    public void onDataAvailable() {
        this.processDataAvailable();
    }

    public void onTimeout(TimeoutException timeout, Promise<Boolean> promise) {
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout on {}", (Object)this, (Object)timeout);
        }
        if ((connection = this.getConnection()) != null) {
            promise.succeeded((Object)connection.onIdleExpired(timeout));
        } else {
            promise.succeeded((Object)true);
        }
    }

    public void onFailure(Throwable failure, Callback callback) {
        callback.failed(failure);
    }
}

