/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.transport;

import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http3.client.HTTP3Client;
import org.eclipse.jetty.http3.client.HTTP3ClientConnectionFactory;
import org.eclipse.jetty.http3.client.transport.internal.SessionClientListener;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.quic.client.QuicTransport;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class ClientConnectionFactoryOverHTTP3
extends ContainerLifeCycle
implements ClientConnectionFactory {
    private final HTTP3ClientConnectionFactory factory = new HTTP3ClientConnectionFactory();

    public ClientConnectionFactoryOverHTTP3(HTTP3Client http3Client) {
        this.installBean(http3Client);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        return this.factory.newConnection(endPoint, context);
    }

    public static class HTTP3
    extends ClientConnectionFactory.Info
    implements ProtocolSession.Factory {
        private static final List<String> protocols = List.of("h3");
        private final HTTP3Client http3Client;

        public HTTP3(HTTP3Client client) {
            super((ClientConnectionFactory)new ClientConnectionFactoryOverHTTP3(client));
            this.http3Client = client;
        }

        public HTTP3Client getHTTP3Client() {
            return this.http3Client;
        }

        public List<String> getProtocols(boolean secure) {
            return protocols;
        }

        public Transport newTransport() {
            return new QuicTransport(this.getHTTP3Client().getQuicConfiguration());
        }

        public ProtocolSession newProtocolSession(QuicSession quicSession, Map<String, Object> context) {
            ClientConnectionFactoryOverHTTP3 http3 = (ClientConnectionFactoryOverHTTP3)this.getClientConnectionFactory();
            context.put(HTTP3Client.CLIENT_CONTEXT_KEY, this.http3Client);
            SessionClientListener listener = new SessionClientListener(context);
            context.put(HTTP3Client.SESSION_LISTENER_CONTEXT_KEY, listener);
            return http3.factory.newProtocolSession(quicSession, context);
        }

        public String toString() {
            return String.format("%s@%x", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode());
        }
    }
}

