/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.transport.internal;

import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.http3.HTTP3Session;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.client.HTTP3SessionClient;
import org.eclipse.jetty.http3.client.transport.internal.HttpConnectionOverHTTP3;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.util.Promise;

public class SessionClientListener
implements Session.Client.Listener {
    private final AtomicMarkableReference<HttpConnectionOverHTTP3> connection = new AtomicMarkableReference<Object>(null, false);
    private final Map<String, Object> context;

    public SessionClientListener(Map<String, Object> context) {
        this.context = context;
    }

    public void onConnect(Session.Client session, Throwable failure) {
        if (failure != null) {
            this.failConnectionPromise(failure);
        }
    }

    private Destination destination() {
        return (Destination)this.context.get("org.eclipse.jetty.client.destination");
    }

    public void onSettings(Session session, SettingsFrame frame) {
        HttpConnectionOverHTTP3 connection = (HttpConnectionOverHTTP3)this.newConnection(this.destination(), (HTTP3SessionClient)session);
        if (this.connection.compareAndSet(null, connection, false, true)) {
            this.destination().getHttpClient().getExecutor().execute(() -> this.httpConnectionPromise().succeeded((Object)connection));
        }
    }

    public boolean onIdleTimeout(Session session) {
        long idleTimeout = ((HTTP3Session)session).getIdleTimeout();
        TimeoutException timeout = new TimeoutException("idle timeout expired: " + idleTimeout + " ms");
        if (this.failConnectionPromise(timeout)) {
            return true;
        }
        HttpConnectionOverHTTP3 connection = this.connection.getReference();
        if (connection != null) {
            return connection.onIdleTimeout(idleTimeout, timeout);
        }
        return true;
    }

    public void onDisconnect(Session session, long error, String reason) {
        this.onFailure(session, error, reason, new ClosedChannelException());
    }

    public void onFailure(Session session, long error, String reason, Throwable failure) {
        if (this.failConnectionPromise(failure)) {
            return;
        }
        HttpConnectionOverHTTP3 connection = this.connection.getReference();
        if (connection != null) {
            connection.close(failure);
        }
    }

    protected Connection newConnection(Destination destination, HTTP3SessionClient session) {
        return new HttpConnectionOverHTTP3(destination, session);
    }

    private Promise<Connection> httpConnectionPromise() {
        return (Promise)this.context.get("org.eclipse.jetty.client.connection.promise");
    }

    private boolean failConnectionPromise(Throwable failure) {
        boolean result = this.connection.compareAndSet(null, null, false, true);
        if (result) {
            this.httpConnectionPromise().failed(failure);
        }
        return result;
    }
}

