/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.transport.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.HttpSender;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http3.HTTP3Stream;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.client.HTTP3SessionClient;
import org.eclipse.jetty.http3.client.transport.internal.HttpChannelOverHTTP3;
import org.eclipse.jetty.http3.frames.DataFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class HttpSenderOverHTTP3
extends HttpSender {
    public HttpSenderOverHTTP3(HttpChannelOverHTTP3 channel) {
        super((HttpChannel)channel);
    }

    protected HttpChannelOverHTTP3 getHttpChannel() {
        return (HttpChannelOverHTTP3)super.getHttpChannel();
    }

    protected void sendHeaders(HttpExchange exchange, ByteBuffer contentBuffer, boolean lastContent, Callback callback) {
        HeadersFrame headersFrame;
        MetaData.ConnectRequest metaData;
        HttpRequest request = exchange.getRequest();
        boolean isTunnel = HttpMethod.CONNECT.is(request.getMethod());
        if (isTunnel) {
            String upgradeProtocol = (String)request.getAttributes().get(HttpUpgrader.PROTOCOL_ATTRIBUTE);
            if (upgradeProtocol == null) {
                metaData = new MetaData.ConnectRequest((String)null, new HostPortHttpField(request.getPath()), null, request.getHeaders(), null);
            } else {
                HostPortHttpField authority = new HostPortHttpField(request.getHost(), request.getPort());
                metaData = new MetaData.ConnectRequest(request.getScheme(), authority, request.getPath(), request.getHeaders(), upgradeProtocol);
            }
        } else {
            String path = this.relativize(request.getPath());
            HttpURI.Mutable uri = HttpURI.build().scheme(request.getScheme()).host(request.getHost()).port(request.getPort()).path(path).query(request.getQuery());
            metaData = new MetaData.Request(request.getMethod(), (HttpURI)uri, HttpVersion.HTTP_3, request.getHeaders(), -1L, request.getTrailersSupplier());
        }
        DataFrame dataFrame = null;
        HeadersFrame trailerFrame = null;
        if (isTunnel) {
            headersFrame = new HeadersFrame((MetaData)metaData, false);
        } else {
            boolean hasContent = BufferUtil.hasContent((ByteBuffer)contentBuffer);
            if (hasContent) {
                headersFrame = new HeadersFrame((MetaData)metaData, false);
                if (lastContent) {
                    trailers = this.retrieveTrailers(request);
                    hasTrailers = trailers != null;
                    dataFrame = new DataFrame(contentBuffer, !hasTrailers);
                    if (hasTrailers) {
                        trailerFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                    }
                } else {
                    dataFrame = new DataFrame(contentBuffer, false);
                }
            } else if (lastContent) {
                trailers = this.retrieveTrailers(request);
                hasTrailers = trailers != null;
                headersFrame = new HeadersFrame((MetaData)metaData, !hasTrailers);
                if (hasTrailers) {
                    trailerFrame = new HeadersFrame(new MetaData(HttpVersion.HTTP_3, trailers), true);
                }
            } else {
                headersFrame = new HeadersFrame((MetaData)metaData, false);
            }
        }
        HeadersFrame hf = headersFrame;
        DataFrame df = dataFrame;
        HeadersFrame tf = trailerFrame;
        HTTP3SessionClient session = this.getHttpChannel().getSession();
        CompletionStage completable = session.newRequest(hf, this.getHttpChannel().getStreamListener()).thenApply(stream -> this.onNewStream((Stream)stream, request));
        if (df != null) {
            completable = ((CompletableFuture)completable).thenCompose(stream -> stream.data(df));
        }
        if (tf != null) {
            completable = ((CompletableFuture)completable).thenCompose(stream -> stream.trailer(tf));
        }
        callback.completeWith((CompletableFuture)completable);
    }

    private Stream onNewStream(Stream stream, HttpRequest request) {
        long idleTimeout = request.getIdleTimeout();
        if (idleTimeout > 0L) {
            ((HTTP3Stream)stream).setIdleTimeout(idleTimeout);
        }
        return stream;
    }

    private HttpFields retrieveTrailers(HttpRequest request) {
        Supplier trailerSupplier = request.getTrailersSupplier();
        HttpFields trailers = trailerSupplier == null ? null : (HttpFields)trailerSupplier.get();
        return trailers == null || trailers.size() == 0 ? null : trailers;
    }

    protected void sendContent(HttpExchange exchange, ByteBuffer contentBuffer, boolean lastContent, Callback callback) {
        Stream stream = this.getHttpChannel().getStream();
        boolean hasContent = contentBuffer.hasRemaining();
        if (lastContent) {
            boolean hasTrailers;
            HttpFields trailers = this.retrieveTrailers(exchange.getRequest());
            boolean bl = hasTrailers = trailers != null && trailers.size() > 0;
            if (hasContent) {
                DataFrame dataFrame = new DataFrame(contentBuffer, !hasTrailers);
                CompletionStage completable = hasTrailers ? stream.data(dataFrame).thenCompose(s -> this.sendTrailer((Stream)s, trailers)) : stream.data(dataFrame);
                callback.completeWith(completable);
            } else {
                CompletableFuture completable = hasTrailers ? this.sendTrailer(stream, trailers) : stream.data(new DataFrame(contentBuffer, true));
                callback.completeWith(completable);
            }
        } else if (hasContent) {
            CompletableFuture completable = stream.data(new DataFrame(contentBuffer, false));
            callback.completeWith(completable);
        } else {
            callback.succeeded();
        }
    }

    private CompletableFuture<Stream> sendTrailer(Stream stream, HttpFields trailers) {
        MetaData metaData = new MetaData(HttpVersion.HTTP_3, trailers);
        HeadersFrame trailerFrame = new HeadersFrame(metaData, true);
        return stream.trailer(trailerFrame);
    }
}

