/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client;

import java.net.SocketAddress;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.http3.HTTP3Configuration;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.client.HTTP3ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.quic.client.QuicClientConnectorConfigurator;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.common.QuicConnection;
import org.eclipse.jetty.quic.common.QuicSessionContainer;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3Client
extends ContainerLifeCycle {
    public static final String CLIENT_CONTEXT_KEY = HTTP3Client.class.getName();
    public static final String SESSION_LISTENER_CONTEXT_KEY = CLIENT_CONTEXT_KEY + ".listener";
    public static final String SESSION_PROMISE_CONTEXT_KEY = CLIENT_CONTEXT_KEY + ".promise";
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3Client.class);
    private final HTTP3Configuration http3Configuration = new HTTP3Configuration();
    private final QuicSessionContainer container = new QuicSessionContainer();
    private final ClientConnector connector;
    private final QuicConfiguration quicConfiguration;

    public HTTP3Client() {
        QuicClientConnectorConfigurator configurator = new QuicClientConnectorConfigurator(this::configureConnection);
        this.connector = new ClientConnector((ClientConnector.Configurator)configurator);
        this.quicConfiguration = configurator.getQuicConfiguration();
        this.addBean(this.connector);
        this.addBean(this.quicConfiguration);
        this.addBean(this.http3Configuration);
        this.addBean(this.container);
        this.quicConfiguration.setMaxUnidirectionalRemoteStreams(48);
        this.quicConfiguration.setUnidirectionalStreamRecvWindow(0x400000);
        this.quicConfiguration.setProtocols(List.of("h3"));
    }

    public ClientConnector getClientConnector() {
        return this.connector;
    }

    public QuicConfiguration getQuicConfiguration() {
        return this.quicConfiguration;
    }

    public HTTP3Configuration getHTTP3Configuration() {
        return this.http3Configuration;
    }

    protected void doStart() throws Exception {
        LOG.info("HTTP/3+QUIC support is experimental and not suited for production use.");
        super.doStart();
    }

    public CompletableFuture<Session.Client> connect(SocketAddress address, Session.Client.Listener listener) {
        ConcurrentHashMap<String, Object> context = new ConcurrentHashMap<String, Object>();
        return this.connect(address, listener, context);
    }

    public CompletableFuture<Session.Client> connect(SocketAddress address, Session.Client.Listener listener, Map<String, Object> context) {
        Promise.Completable completable = new Promise.Completable();
        context.put(CLIENT_CONTEXT_KEY, (Object)this);
        context.put(SESSION_LISTENER_CONTEXT_KEY, listener);
        context.put(SESSION_PROMISE_CONTEXT_KEY, completable);
        context.computeIfAbsent("org.eclipse.jetty.client.connector.clientConnectionFactory", key -> new HTTP3ClientConnectionFactory());
        context.put("org.eclipse.jetty.client.connector.connectionPromise", Promise.from(ioConnection -> {}, arg_0 -> ((Promise.Completable)completable).failed(arg_0)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("connecting to {}", (Object)address);
        }
        this.connector.connect(address, context);
        return completable;
    }

    private Connection configureConnection(Connection connection) {
        if (connection instanceof QuicConnection) {
            QuicConnection quicConnection = (QuicConnection)connection;
            quicConnection.addEventListener((EventListener)this.container);
            quicConnection.setInputBufferSize(this.getHTTP3Configuration().getInputBufferSize());
            quicConnection.setOutputBufferSize(this.getHTTP3Configuration().getOutputBufferSize());
            quicConnection.setUseInputDirectByteBuffers(this.getHTTP3Configuration().isUseInputDirectByteBuffers());
            quicConnection.setUseOutputDirectByteBuffers(this.getHTTP3Configuration().isUseOutputDirectByteBuffers());
        }
        return connection;
    }

    public CompletableFuture<Void> shutdown() {
        return this.container.shutdown();
    }
}

