/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.compression.NBitIntegerEncoder;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class StreamCancellationInstruction
implements Instruction {
    private final long _streamId;

    public StreamCancellationInstruction(long streamId) {
        this._streamId = streamId;
    }

    @Override
    public void encode(ByteBufferPool byteBufferPool, ByteBufferPool.Accumulator accumulator) {
        int size = NBitIntegerEncoder.octetsNeeded((int)6, (long)this._streamId);
        RetainableByteBuffer retainableByteBuffer = byteBufferPool.acquire(size, false);
        ByteBuffer buffer = retainableByteBuffer.getByteBuffer();
        BufferUtil.clearToFill((ByteBuffer)buffer);
        buffer.put((byte)64);
        NBitIntegerEncoder.encode((ByteBuffer)buffer, (int)6, (long)this._streamId);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        accumulator.append(retainableByteBuffer);
    }

    public String toString() {
        return String.format("%s@%x[stream=%d]", this.getClass().getSimpleName(), this.hashCode(), this._streamId);
    }
}

