/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.util.Objects;
import org.eclipse.jetty.reactive.client.internal.AbstractSinglePublisher;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.thread.AutoLock;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractSingleProcessor<I, O>
extends AbstractSinglePublisher<O>
implements Processor<I, O> {
    private Subscription upStream;
    private long demand;

    protected Subscriber<? super O> downStream() {
        return this.subscriber();
    }

    @Override
    protected void onFailure(Subscriber<? super O> subscriber, Throwable failure) {
        this.upStreamCancel();
        super.onFailure(subscriber, failure);
    }

    @Override
    public void cancel() {
        this.upStreamCancel();
        super.cancel();
    }

    protected void upStreamCancel() {
        Subscription upStream;
        try (AutoLock ignored = this.lock();){
            upStream = this.upStream;
            this.upStream = null;
        }
        if (upStream != null) {
            upStream.cancel();
        }
    }

    @Override
    protected void onRequest(Subscriber<? super O> subscriber, long n) {
        Subscription upStream;
        long demand;
        try (AutoLock ignored = this.lock();){
            demand = MathUtils.cappedAdd((long)this.demand, (long)n);
            upStream = this.upStream;
            this.demand = upStream == null ? demand : 0L;
        }
        this.upStreamRequest(upStream, demand);
    }

    protected void upStreamRequest(long n) {
        this.upStreamRequest(this.upStream(), n);
    }

    private void upStreamRequest(Subscription upStream, long demand) {
        if (upStream != null) {
            upStream.request(demand);
        }
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "invalid 'null' subscription");
        long demand = 0L;
        IllegalStateException failure = null;
        try (AutoLock ignored = this.lock();){
            if (this.upStream != null) {
                failure = new IllegalStateException("multiple subscriptions not supported");
            } else {
                this.upStream = subscription;
                demand = this.demand;
                this.demand = 0L;
            }
        }
        if (failure != null) {
            subscription.cancel();
            this.downStreamOnError(failure);
        } else if (demand > 0L) {
            subscription.request(demand);
        }
    }

    private Subscription upStream() {
        try (AutoLock ignored = this.lock();){
            Subscription subscription = this.upStream;
            return subscription;
        }
    }

    protected void downStreamOnNext(O item) {
        Subscriber<O> downStream = this.downStream();
        if (downStream != null) {
            this.emitOnNext(downStream, item);
        }
    }

    public void onError(Throwable throwable) {
        this.downStreamOnError(throwable);
    }

    private void downStreamOnError(Throwable throwable) {
        Subscriber<O> downStream = this.downStream();
        if (downStream != null) {
            this.emitOnError(downStream, throwable);
        }
    }

    public void onComplete() {
        this.downStreamOnComplete();
    }

    private void downStreamOnComplete() {
        Subscriber<O> downStream = this.downStream();
        if (downStream != null) {
            this.emitOnComplete(downStream);
        }
    }

    @Override
    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

