/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public final class RuntimeUtil {
    public static String generateThreadDump() {
        ThreadInfo[] threads;
        StringBuilder ret = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo thread : threads = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 400)) {
            StackTraceElement[] stackTraceElements;
            Thread.State state = thread.getThreadState();
            ret.append('\"').append(thread.getThreadName()).append("\" ");
            ret.append(" #").append(thread.getThreadId());
            if (thread.isInNative()) {
                ret.append(" in-native");
            }
            if (thread.isSuspended()) {
                ret.append(" suspended");
            }
            if (state == Thread.State.BLOCKED) {
                if (thread.getBlockedTime() != -1L) {
                    ret.append(" blockedTime=").append(thread.getBlockedTime()).append("ms");
                }
                ret.append(" blockedCount=").append(thread.getBlockedCount());
            }
            if (state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING) {
                if (thread.getWaitedTime() != -1L) {
                    ret.append(" waitedTime=").append(thread.getWaitedTime()).append("ms");
                }
                ret.append(" waitedCount=").append(thread.getWaitedCount());
            }
            ret.append("\n   java.lang.Thread.State: ").append(state.name());
            if (state == Thread.State.BLOCKED || state == Thread.State.TIMED_WAITING || state == Thread.State.WAITING) {
                Object[] synchronizers;
                Object[] monitors;
                ret.append(" (locked on ").append(thread.getLockInfo()).append(')');
                if (thread.getLockOwnerId() != -1L) {
                    ret.append(" (owner=").append(thread.getLockOwnerName());
                    ret.append('/').append(thread.getLockOwnerId());
                    ret.append(')');
                }
                if ((monitors = thread.getLockedMonitors()).length > 0) {
                    ret.append(" (monitors=");
                    RuntimeUtil.joinToStrings(ret, "[", ",", "]", monitors);
                    ret.append(')');
                }
                if ((synchronizers = thread.getLockedSynchronizers()).length > 0) {
                    ret.append(" (synchronizers=");
                    RuntimeUtil.joinToStrings(ret, "[", ",", "]", synchronizers);
                    ret.append(')');
                }
            }
            for (StackTraceElement stackTraceElement : stackTraceElements = thread.getStackTrace()) {
                ret.append("\n\tat ");
                ret.append(stackTraceElement);
            }
            ret.append("\n\n");
        }
        return ret.toString();
    }

    private static void joinToStrings(StringBuilder ret, String prefixStr, String delimStr, String suffixStr, Object[] objects) {
        ret.append(prefixStr);
        boolean delim = false;
        if (objects != null) {
            for (Object obj : objects) {
                if (delim) {
                    ret.append(delimStr);
                }
                ret.append(obj);
                delim = true;
            }
        }
        ret.append(suffixStr);
    }
}

