/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jetty.plus.annotation.LifeCycleCallback;
import org.eclipse.jetty.plus.annotation.PostConstructCallback;
import org.eclipse.jetty.plus.annotation.PreDestroyCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class LifeCycleCallbackCollection {
    private static final Logger LOG = Log.getLogger(LifeCycleCallbackCollection.class);
    public static final String LIFECYCLE_CALLBACK_COLLECTION = "org.eclipse.jetty.lifecyleCallbackCollection";
    private final ConcurrentMap<String, Set<LifeCycleCallback>> postConstructCallbacksMap = new ConcurrentHashMap<String, Set<LifeCycleCallback>>();
    private final ConcurrentMap<String, Set<LifeCycleCallback>> preDestroyCallbacksMap = new ConcurrentHashMap<String, Set<LifeCycleCallback>>();

    public void add(LifeCycleCallback callback) {
        if (callback == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring empty LifeCycleCallback", new Object[0]);
            }
            return;
        }
        ConcurrentMap<String, Set<LifeCycleCallback>> map = null;
        if (callback instanceof PreDestroyCallback) {
            map = this.preDestroyCallbacksMap;
        } else if (callback instanceof PostConstructCallback) {
            map = this.postConstructCallbacksMap;
        } else {
            throw new IllegalArgumentException("Unsupported lifecycle callback type: " + callback);
        }
        Set<LifeCycleCallback> callbacks = (CopyOnWriteArraySet<LifeCycleCallback>)map.get(callback.getTargetClassName());
        if (callbacks == null) {
            callbacks = new CopyOnWriteArraySet<LifeCycleCallback>();
            Set tmp = map.putIfAbsent(callback.getTargetClassName(), callbacks);
            if (tmp != null) {
                callbacks = tmp;
            }
        }
        boolean added = callbacks.add(callback);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding callback for class={} on method={} added={}", callback.getTargetClassName(), callback.getMethodName(), added);
        }
    }

    public Set<LifeCycleCallback> getPreDestroyCallbacks(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        return (Set)this.preDestroyCallbacksMap.get(clazz.getName());
    }

    public Set<LifeCycleCallback> getPostConstructCallbacks(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> clazz = o.getClass();
        return (Set)this.postConstructCallbacksMap.get(clazz.getName());
    }

    public void callPostConstructCallback(Object o) throws Exception {
        if (o == null) {
            return;
        }
        Class<?> clazz = o.getClass();
        Set callbacks = (Set)this.postConstructCallbacksMap.get(clazz.getName());
        if (callbacks == null) {
            return;
        }
        for (LifeCycleCallback l : callbacks) {
            l.callback(o);
        }
    }

    public void callPreDestroyCallback(Object o) throws Exception {
        if (o == null) {
            return;
        }
        Class<?> clazz = o.getClass();
        Set callbacks = (Set)this.preDestroyCallbacksMap.get(clazz.getName());
        if (callbacks == null) {
            return;
        }
        for (LifeCycleCallback l : callbacks) {
            l.callback(o);
        }
    }

    public Map<String, Set<LifeCycleCallback>> getPostConstructCallbackMap() {
        return Collections.unmodifiableMap(this.postConstructCallbacksMap);
    }

    public Map<String, Set<LifeCycleCallback>> getPreDestroyCallbackMap() {
        return Collections.unmodifiableMap(this.preDestroyCallbacksMap);
    }

    public Collection<LifeCycleCallback> getPostConstructCallbacks() {
        HashSet set = new HashSet();
        for (String s : this.postConstructCallbacksMap.keySet()) {
            set.addAll((Collection)this.postConstructCallbacksMap.get(s));
        }
        return Collections.unmodifiableCollection(set);
    }

    public Collection<LifeCycleCallback> getPreDestroyCallbacks() {
        HashSet set = new HashSet();
        for (String s : this.preDestroyCallbacksMap.keySet()) {
            set.addAll((Collection)this.preDestroyCallbacksMap.get(s));
        }
        return Collections.unmodifiableCollection(set);
    }
}

