/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.resource.Resource;

public class ServletTester
extends ContainerLifeCycle {
    private final Server _server = new Server();
    private final LocalConnector _connector = new LocalConnector(this._server);
    private final ServletContextHandler _context;
    private final ServletHandler _handler;

    public Server getServer() {
        return this._server;
    }

    public LocalConnector getConnector() {
        return this._connector;
    }

    public void setVirtualHosts(String[] vhosts) {
        this._context.setVirtualHosts(vhosts);
    }

    public void addVirtualHosts(String[] virtualHosts) {
        this._context.addVirtualHosts(virtualHosts);
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this._context.addServlet(className, pathSpec);
    }

    public ServletHolder addServlet(Class<? extends Servlet> servlet, String pathSpec) {
        return this._context.addServlet(servlet, pathSpec);
    }

    public void addServlet(ServletHolder servlet, String pathSpec) {
        this._context.addServlet(servlet, pathSpec);
    }

    public void addFilter(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        this._context.addFilter(holder, pathSpec, dispatches);
    }

    public FilterHolder addFilter(Class<? extends Filter> filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        return this._context.addFilter(filterClass, pathSpec, dispatches);
    }

    public FilterHolder addFilter(String filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        return this._context.addFilter(filterClass, pathSpec, dispatches);
    }

    public Object getAttribute(String name) {
        return this._context.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._context.getAttributeNames();
    }

    public Attributes getAttributes() {
        return this._context.getAttributes();
    }

    public String getContextPath() {
        return this._context.getContextPath();
    }

    public String getInitParameter(String name) {
        return this._context.getInitParameter(name);
    }

    public String setInitParameter(String name, String value) {
        return this._context.setInitParameter(name, value);
    }

    public Enumeration getInitParameterNames() {
        return this._context.getInitParameterNames();
    }

    public Map<String, String> getInitParams() {
        return this._context.getInitParams();
    }

    public void removeAttribute(String name) {
        this._context.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._context.setAttribute(name, value);
    }

    public void setContextPath(String contextPath) {
        this._context.setContextPath(contextPath);
    }

    public Resource getBaseResource() {
        return this._context.getBaseResource();
    }

    public String getResourceBase() {
        return this._context.getResourceBase();
    }

    public void setResourceBase(String resourceBase) {
        this._context.setResourceBase(resourceBase);
    }

    public ServletTester() {
        this("/", 3);
    }

    public ServletTester(String ctxPath) {
        this(ctxPath, 3);
    }

    public ServletTester(String contextPath, int options) {
        this._context = new ServletContextHandler((HandlerContainer)this._server, contextPath, options);
        this._handler = this._context.getServletHandler();
        this._server.setConnectors(new Connector[]{this._connector});
        this.addBean(this._server);
    }

    public ServletContextHandler getContext() {
        return this._context;
    }

    public String getResponses(String request) throws Exception {
        return this._connector.getResponses(request);
    }

    public ByteBuffer getResponses(ByteBuffer request) throws Exception {
        return this._connector.getResponses(request);
    }

    public String createConnector(boolean localhost) throws Exception {
        ServerConnector connector = new ServerConnector(this._server);
        if (localhost) {
            connector.setHost("127.0.0.1");
        }
        this._server.addConnector((Connector)connector);
        if (this._server.isStarted()) {
            connector.start();
        } else {
            connector.open();
        }
        return "http://" + (localhost ? "127.0.0.1" : InetAddress.getLocalHost().getHostAddress()) + ":" + connector.getLocalPort();
    }

    public LocalConnector createLocalConnector() {
        LocalConnector connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)connector);
        return connector;
    }
}

