/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.foreign.linux;

import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.lang.invoke.VarHandle;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jetty.quic.quiche.foreign.NativeHelper;

public class sockaddr_linux {
    private static final short AF_INET = 2;
    private static final short AF_INET6 = 10;

    public static MemorySegment convert(SocketAddress socketAddress, SegmentAllocator scope) {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Expected InetSocketAddress instance, got: " + String.valueOf(socketAddress));
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress address = inetSocketAddress.getAddress();
        if (address instanceof Inet4Address) {
            MemorySegment sin = sockaddr_in.allocate(scope);
            sockaddr_in.set_sin_family(sin, (short)2);
            sockaddr_in.set_sin_port(sin, (short)inetSocketAddress.getPort());
            sockaddr_in.set_sin_addr(sin, ByteBuffer.wrap(address.getAddress()).getInt());
            return sin;
        }
        if (address instanceof Inet6Address) {
            MemorySegment sin6 = sockaddr_in6.allocate(scope);
            sockaddr_in6.set_sin6_family(sin6, (short)10);
            sockaddr_in6.set_sin6_port(sin6, (short)inetSocketAddress.getPort());
            sockaddr_in6.set_sin6_addr(sin6, address.getAddress());
            sockaddr_in6.set_sin6_scope_id(sin6, 0);
            sockaddr_in6.set_sin6_flowinfo(sin6, 0);
            return sin6;
        }
        throw new UnsupportedOperationException("Unsupported InetAddress: " + String.valueOf(address));
    }

    private static class sockaddr_in {
        private static final MemoryLayout LAYOUT = MemoryLayout.structLayout(NativeHelper.C_SHORT.withName("sin_family"), NativeHelper.C_SHORT.withName("sin_port"), NativeHelper.C_INT.withName("sin_addr"), MemoryLayout.sequenceLayout(8L, NativeHelper.C_CHAR).withName("sin_zero")).withName("sockaddr_in");
        private static final VarHandle sin_family = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sin_family"));
        private static final VarHandle sin_port = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sin_port"));
        private static final VarHandle sin_addr = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sin_addr"));

        private sockaddr_in() {
        }

        public static MemorySegment allocate(SegmentAllocator scope) {
            return scope.allocate(LAYOUT);
        }

        public static void set_sin_family(MemorySegment sin, short value) {
            sin_family.set(sin, 0L, value);
        }

        public static void set_sin_port(MemorySegment sin, short value) {
            sin_port.set(sin, 0L, value);
        }

        public static void set_sin_addr(MemorySegment sin, int value) {
            sin_addr.set(sin, 0L, value);
        }
    }

    private static class sockaddr_in6 {
        private static final MemoryLayout LAYOUT = MemoryLayout.structLayout(NativeHelper.C_SHORT.withName("sin6_family"), NativeHelper.C_SHORT.withName("sin6_port"), NativeHelper.C_INT.withName("sin6_flowinfo"), MemoryLayout.sequenceLayout(16L, NativeHelper.C_CHAR).withName("sin6_addr"), NativeHelper.C_INT.withName("sin6_scope_id")).withName("sockaddr_in6");
        private static final VarHandle sin6_family = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sin6_family"));
        private static final VarHandle sin6_port = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sin6_port"));
        private static final VarHandle sin6_scope_id = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sin6_scope_id"));
        private static final VarHandle sin6_flowinfo = LAYOUT.varHandle(MemoryLayout.PathElement.groupElement("sin6_flowinfo"));

        private sockaddr_in6() {
        }

        public static MemorySegment allocate(SegmentAllocator scope) {
            return scope.allocate(LAYOUT);
        }

        public static void set_sin6_addr(MemorySegment sin6, byte[] value) {
            sin6.asSlice(8L, 16L).asByteBuffer().order(ByteOrder.nativeOrder()).put(value);
        }

        public static void set_sin6_family(MemorySegment sin6, short value) {
            sin6_family.set(sin6, 0L, value);
        }

        public static void set_sin6_port(MemorySegment sin6, short value) {
            sin6_port.set(sin6, 0L, value);
        }

        public static void set_sin6_scope_id(MemorySegment sin6, int value) {
            sin6_scope_id.set(sin6, 0L, value);
        }

        public static void set_sin6_flowinfo(MemorySegment sin6, int value) {
            sin6_flowinfo.set(sin6, 0L, value);
        }
    }
}

