/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.ObjectDirectory;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.junit.MockSystemReader;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RefWriter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;
import org.junit.Assert;

public class TestRepository<R extends Repository> {
    private static final PersonIdent defaultAuthor;
    private static final PersonIdent defaultCommitter;
    private final R db;
    private final Git git;
    private final RevWalk pool;
    private final ObjectInserter inserter;
    private final MockSystemReader mockSystemReader;

    public TestRepository(R db) throws IOException {
        this(db, new RevWalk(db), new MockSystemReader());
    }

    public TestRepository(R db, RevWalk rw) throws IOException {
        this(db, rw, new MockSystemReader());
    }

    public TestRepository(R db, RevWalk rw, MockSystemReader reader) throws IOException {
        this.db = db;
        this.git = Git.wrap(db);
        this.pool = rw;
        this.inserter = db.newObjectInserter();
        this.mockSystemReader = reader;
    }

    public R getRepository() {
        return this.db;
    }

    public RevWalk getRevWalk() {
        return this.pool;
    }

    public Git git() {
        return this.git;
    }

    public Date getDate() {
        return new Date(this.mockSystemReader.getCurrentTime());
    }

    @Deprecated
    public Date getClock() {
        return this.getDate();
    }

    public TimeZone getTimeZone() {
        return this.mockSystemReader.getTimeZone();
    }

    public void tick(int secDelta) {
        this.mockSystemReader.tick(secDelta);
    }

    public void setAuthorAndCommitter(org.eclipse.jgit.lib.CommitBuilder c) {
        c.setAuthor(new PersonIdent(defaultAuthor, this.getDate()));
        c.setCommitter(new PersonIdent(defaultCommitter, this.getDate()));
    }

    public RevBlob blob(String content) throws Exception {
        return this.blob(content.getBytes("UTF-8"));
    }

    public RevBlob blob(byte[] content) throws Exception {
        ObjectId id;
        try (ObjectInserter ins = this.inserter;){
            id = ins.insert(3, content);
            ins.flush();
        }
        return this.pool.lookupBlob((AnyObjectId)id);
    }

    public DirCacheEntry file(String path, RevBlob blob) throws Exception {
        DirCacheEntry e = new DirCacheEntry(path);
        e.setFileMode(FileMode.REGULAR_FILE);
        e.setObjectId((AnyObjectId)blob);
        return e;
    }

    public RevTree tree(DirCacheEntry ... entries) throws Exception {
        ObjectId root;
        DirCache dc = DirCache.newInCore();
        DirCacheBuilder b = dc.builder();
        for (DirCacheEntry e : entries) {
            b.add(e);
        }
        b.finish();
        try (ObjectInserter ins = this.inserter;){
            root = dc.writeTree(ins);
            ins.flush();
        }
        return this.pool.lookupTree((AnyObjectId)root);
    }

    public RevObject get(RevTree tree, String path) throws Exception {
        try (TreeWalk tw = new TreeWalk(this.pool.getObjectReader());){
            tw.setFilter(PathFilterGroup.createFromStrings(Collections.singleton(path)));
            tw.reset((AnyObjectId)tree);
            while (tw.next()) {
                if (tw.isSubtree() && !path.equals(tw.getPathString())) {
                    tw.enterSubtree();
                    continue;
                }
                ObjectId entid = tw.getObjectId(0);
                FileMode entmode = tw.getFileMode(0);
                RevObject revObject = this.pool.lookupAny((AnyObjectId)entid, entmode.getObjectType());
                return revObject;
            }
        }
        Assert.fail((String)("Can't find " + path + " in tree " + tree.name()));
        return null;
    }

    public RevCommit commit(RevCommit ... parents) throws Exception {
        return this.commit(1, this.tree(new DirCacheEntry[0]), parents);
    }

    public RevCommit commit(RevTree tree, RevCommit ... parents) throws Exception {
        return this.commit(1, tree, parents);
    }

    public RevCommit commit(int secDelta, RevCommit ... parents) throws Exception {
        return this.commit(secDelta, this.tree(new DirCacheEntry[0]), parents);
    }

    public RevCommit commit(int secDelta, RevTree tree, RevCommit ... parents) throws Exception {
        ObjectId id;
        this.tick(secDelta);
        org.eclipse.jgit.lib.CommitBuilder c = new org.eclipse.jgit.lib.CommitBuilder();
        c.setTreeId((AnyObjectId)tree);
        c.setParentIds((ObjectId[])parents);
        c.setAuthor(new PersonIdent(defaultAuthor, this.getDate()));
        c.setCommitter(new PersonIdent(defaultCommitter, this.getDate()));
        c.setMessage("");
        try (ObjectInserter ins = this.inserter;){
            id = ins.insert(c);
            ins.flush();
        }
        return this.pool.lookupCommit((AnyObjectId)id);
    }

    public CommitBuilder commit() {
        return new CommitBuilder();
    }

    public RevTag tag(String name, RevObject dst) throws Exception {
        ObjectId id;
        TagBuilder t = new TagBuilder();
        t.setObjectId(dst);
        t.setTag(name);
        t.setTagger(new PersonIdent(defaultCommitter, this.getDate()));
        t.setMessage("");
        try (ObjectInserter ins = this.inserter;){
            id = ins.insert(t);
            ins.flush();
        }
        return (RevTag)this.pool.lookupAny((AnyObjectId)id, 4);
    }

    public RevCommit update(String ref, CommitBuilder to) throws Exception {
        return this.update(ref, to.create());
    }

    public CommitBuilder amendRef(String ref) throws Exception {
        String name = TestRepository.normalizeRef(ref);
        Ref r = this.db.getRef(name);
        if (r == null) {
            throw new IOException("Not a ref: " + ref);
        }
        return this.amend(this.pool.parseCommit((AnyObjectId)r.getObjectId()), this.branch(name).commit());
    }

    public CommitBuilder amend(AnyObjectId id) throws Exception {
        return this.amend(this.pool.parseCommit(id), this.commit());
    }

    private CommitBuilder amend(RevCommit old, CommitBuilder b) throws Exception {
        this.pool.parseBody((RevObject)old);
        b.author(old.getAuthorIdent());
        b.committer(old.getCommitterIdent());
        b.message(old.getFullMessage());
        b.updateCommitterTime = true;
        b.noParents();
        for (int i = 0; i < old.getParentCount(); ++i) {
            b.parent(old.getParent(i));
        }
        b.tree.clear();
        try (final TreeWalk tw = new TreeWalk(this.db);){
            tw.reset((AnyObjectId)old.getTree());
            tw.setRecursive(true);
            while (tw.next()) {
                b.edit(new DirCacheEditor.PathEdit(tw.getPathString()){

                    public void apply(DirCacheEntry ent) {
                        ent.setFileMode(tw.getFileMode(0));
                        ent.setObjectId((AnyObjectId)tw.getObjectId(0));
                    }
                });
            }
        }
        return b;
    }

    public <T extends AnyObjectId> T update(String ref, T obj) throws Exception {
        ref = TestRepository.normalizeRef(ref);
        RefUpdate u = this.db.updateRef(ref);
        u.setNewObjectId(obj);
        switch (u.forceUpdate()) {
            case FAST_FORWARD: 
            case FORCED: 
            case NEW: 
            case NO_CHANGE: {
                this.updateServerInfo();
                return obj;
            }
        }
        throw new IOException("Cannot write " + ref + " " + u.getResult());
    }

    private static String normalizeRef(String ref) {
        if (!("HEAD".equals(ref) || "FETCH_HEAD".equals(ref) || "MERGE_HEAD".equals(ref) || ref.startsWith("refs/"))) {
            ref = "refs/heads/" + ref;
        }
        return ref;
    }

    public void reset(AnyObjectId id) throws Exception {
        RefUpdate ru = this.db.updateRef("HEAD", true);
        ru.setNewObjectId(id);
        RefUpdate.Result result = ru.forceUpdate();
        switch (result) {
            case FAST_FORWARD: 
            case FORCED: 
            case NEW: 
            case NO_CHANGE: {
                break;
            }
            default: {
                throw new IOException(String.format("Checkout \"%s\" failed: %s", id.name(), result));
            }
        }
    }

    public void reset(String name) throws Exception {
        ObjectId id = this.db.resolve(name);
        if (id == null) {
            throw new IOException("Not a revision: " + name);
        }
        RefUpdate ru = this.db.updateRef("HEAD", false);
        ru.setNewObjectId((AnyObjectId)id);
        RefUpdate.Result result = ru.forceUpdate();
        switch (result) {
            case FAST_FORWARD: 
            case FORCED: 
            case NEW: 
            case NO_CHANGE: {
                break;
            }
            default: {
                throw new IOException(String.format("Checkout \"%s\" failed: %s", name, result));
            }
        }
    }

    public RevCommit cherryPick(AnyObjectId id) throws Exception {
        RevCommit commit = this.pool.parseCommit(id);
        this.pool.parseBody((RevObject)commit);
        if (commit.getParentCount() != 1) {
            throw new IOException(String.format("Expected 1 parent for %s, found: %s", id.name(), Arrays.asList(commit.getParents())));
        }
        RevCommit parent = commit.getParent(0);
        this.pool.parseHeaders((RevObject)parent);
        Ref headRef = this.db.getRef("HEAD");
        if (headRef == null) {
            throw new IOException("Missing HEAD");
        }
        RevCommit head = this.pool.parseCommit((AnyObjectId)headRef.getObjectId());
        ThreeWayMerger merger = MergeStrategy.RECURSIVE.newMerger(this.db, true);
        merger.setBase((AnyObjectId)parent.getTree());
        if (merger.merge(new AnyObjectId[]{head, commit})) {
            ObjectId result;
            if (AnyObjectId.equals((AnyObjectId)head.getTree(), (AnyObjectId)merger.getResultTreeId())) {
                return null;
            }
            this.tick(1);
            org.eclipse.jgit.lib.CommitBuilder b = new org.eclipse.jgit.lib.CommitBuilder();
            b.setParentId((AnyObjectId)head);
            b.setTreeId((AnyObjectId)merger.getResultTreeId());
            b.setAuthor(commit.getAuthorIdent());
            b.setCommitter(new PersonIdent(defaultCommitter, this.getDate()));
            b.setMessage(commit.getFullMessage());
            try (ObjectInserter ins = this.inserter;){
                result = ins.insert(b);
                ins.flush();
            }
            this.update("HEAD", result);
            return this.pool.parseCommit((AnyObjectId)result);
        }
        throw new IOException("Merge conflict");
    }

    public void updateServerInfo() throws Exception {
        if (this.db instanceof FileRepository) {
            final FileRepository fr = (FileRepository)this.db;
            RefWriter rw = new RefWriter(fr.getAllRefs().values()){

                protected void writeFile(String name, byte[] bin) throws IOException {
                    File path = new File(fr.getDirectory(), name);
                    TestRepository.this.writeFile(path, bin);
                }
            };
            rw.writePackedRefs();
            rw.writeInfoRefs();
            StringBuilder w = new StringBuilder();
            for (PackFile p : fr.getObjectDatabase().getPacks()) {
                w.append("P ");
                w.append(p.getPackFile().getName());
                w.append('\n');
            }
            this.writeFile(new File(new File(fr.getObjectDatabase().getDirectory(), "info"), "packs"), Constants.encodeASCII((String)w.toString()));
        }
    }

    public <T extends RevObject> T parseBody(T object) throws Exception {
        this.pool.parseBody(object);
        return object;
    }

    public BranchBuilder branch(String ref) {
        if (!"HEAD".equals(ref) && !ref.startsWith("refs/")) {
            ref = "refs/heads/" + ref;
        }
        return new BranchBuilder(ref);
    }

    public ObjectId lightweightTag(String name, ObjectId obj) throws Exception {
        if (!name.startsWith("refs/tags/")) {
            name = "refs/tags/" + name;
        }
        return this.update(name, obj);
    }

    public void fsck(RevObject ... tips) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try (ObjectWalk ow = new ObjectWalk(this.db);){
            RevCommit o;
            if (tips.length != 0) {
                for (RevObject o2 : tips) {
                    ow.markStart(ow.parseAny((AnyObjectId)o2));
                }
            } else {
                for (Ref r : this.db.getAllRefs().values()) {
                    ow.markStart(ow.parseAny((AnyObjectId)r.getObjectId()));
                }
            }
            ObjectChecker oc = new ObjectChecker();
            while ((o = ow.next()) != null) {
                byte[] bin = this.db.open((AnyObjectId)o, o.getType()).getCachedBytes();
                oc.checkCommit(bin);
                TestRepository.assertHash((RevObject)o, bin);
            }
            while ((o = ow.nextObject()) != null) {
                byte[] bin = this.db.open((AnyObjectId)o, o.getType()).getCachedBytes();
                oc.check(o.getType(), bin);
                TestRepository.assertHash((RevObject)o, bin);
            }
        }
    }

    private static void assertHash(RevObject id, byte[] bin) {
        MessageDigest md = Constants.newMessageDigest();
        md.update(Constants.encodedTypeString((int)id.getType()));
        md.update((byte)32);
        md.update(Constants.encodeASCII((long)bin.length));
        md.update((byte)0);
        md.update(bin);
        Assert.assertEquals((Object)id, (Object)ObjectId.fromRaw((byte[])md.digest()));
    }

    public void packAndPrune() throws Exception {
        if (this.db.getObjectDatabase() instanceof ObjectDirectory) {
            File pack;
            ObjectDirectory odb = (ObjectDirectory)this.db.getObjectDatabase();
            NullProgressMonitor m = NullProgressMonitor.INSTANCE;
            try (PackWriter pw = new PackWriter(this.db);){
                HashSet<ObjectId> all = new HashSet<ObjectId>();
                for (Ref r : this.db.getAllRefs().values()) {
                    all.add(r.getObjectId());
                }
                pw.preparePack((ProgressMonitor)m, all, Collections.emptySet());
                ObjectId name = pw.computeName();
                pack = TestRepository.nameFor(odb, name, ".pack");
                try (SafeBufferedOutputStream out = new SafeBufferedOutputStream((OutputStream)new FileOutputStream(pack));){
                    pw.writePack((ProgressMonitor)m, (ProgressMonitor)m, (OutputStream)out);
                }
                pack.setReadOnly();
                File idx = TestRepository.nameFor(odb, name, ".idx");
                out = new SafeBufferedOutputStream((OutputStream)new FileOutputStream(idx));
                var10_11 = null;
                try {
                    pw.writeIndex((OutputStream)out);
                }
                catch (Throwable throwable) {
                    var10_11 = throwable;
                    throw throwable;
                }
                finally {
                    if (out != null) {
                        if (var10_11 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable x2) {
                                var10_11.addSuppressed(x2);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
                idx.setReadOnly();
            }
            odb.openPack(pack);
            this.updateServerInfo();
            TestRepository.prunePacked(odb);
        }
    }

    private static void prunePacked(ObjectDirectory odb) throws IOException {
        for (PackFile p : odb.getPacks()) {
            for (PackIndex.MutableEntry e : p) {
                FileUtils.delete((File)odb.fileFor((AnyObjectId)e.toObjectId()));
            }
        }
    }

    private static File nameFor(ObjectDirectory odb, ObjectId name, String t) {
        File packdir = new File(odb.getDirectory(), "pack");
        return new File(packdir, "pack-" + name.name() + t);
    }

    private void writeFile(File p, byte[] bin) throws IOException, ObjectWritingException {
        LockFile lck = new LockFile(p, this.db.getFS());
        if (!lck.lock()) {
            throw new ObjectWritingException("Can't write " + p);
        }
        try {
            lck.write(bin);
        }
        catch (IOException ioe) {
            throw new ObjectWritingException("Can't write " + p);
        }
        if (!lck.commit()) {
            throw new ObjectWritingException("Can't write " + p);
        }
    }

    static {
        MockSystemReader m = new MockSystemReader();
        long now = m.getCurrentTime();
        int tz = m.getTimezone(now);
        String an = "J. Author";
        String ae = "jauthor@example.com";
        defaultAuthor = new PersonIdent("J. Author", "jauthor@example.com", now, tz);
        String cn = "J. Committer";
        String ce = "jcommitter@example.com";
        defaultCommitter = new PersonIdent("J. Committer", "jcommitter@example.com", now, tz);
    }

    public class BranchBuilder {
        private final String ref;

        BranchBuilder(String ref) {
            this.ref = ref;
        }

        public CommitBuilder commit() throws Exception {
            return new CommitBuilder(this);
        }

        public RevCommit update(CommitBuilder to) throws Exception {
            return this.update(to.create());
        }

        public RevCommit update(RevCommit to) throws Exception {
            return TestRepository.this.update(this.ref, to);
        }
    }

    public class CommitBuilder {
        private final BranchBuilder branch;
        private final DirCache tree = DirCache.newInCore();
        private ObjectId topLevelTree;
        private final List<RevCommit> parents = new ArrayList<RevCommit>(2);
        private int tick = 1;
        private String message = "";
        private RevCommit self;
        private PersonIdent author;
        private PersonIdent committer;
        private String changeId;
        private boolean updateCommitterTime;

        CommitBuilder() {
            this.branch = null;
        }

        CommitBuilder(BranchBuilder b) throws Exception {
            this.branch = b;
            Ref ref = TestRepository.this.db.getRef(this.branch.ref);
            if (ref != null && ref.getObjectId() != null) {
                this.parent(TestRepository.this.pool.parseCommit((AnyObjectId)ref.getObjectId()));
            }
        }

        CommitBuilder(CommitBuilder prior) throws Exception {
            this.branch = prior.branch;
            DirCacheBuilder b = this.tree.builder();
            for (int i = 0; i < prior.tree.getEntryCount(); ++i) {
                b.add(prior.tree.getEntry(i));
            }
            b.finish();
            this.parents.add(prior.create());
        }

        public CommitBuilder parent(RevCommit p) throws Exception {
            if (this.parents.isEmpty()) {
                DirCacheBuilder b = this.tree.builder();
                TestRepository.this.parseBody(p);
                b.addTree(new byte[0], 0, TestRepository.this.pool.getObjectReader(), (AnyObjectId)p.getTree());
                b.finish();
            }
            this.parents.add(p);
            return this;
        }

        public List<RevCommit> parents() {
            return Collections.unmodifiableList(this.parents);
        }

        public CommitBuilder noParents() {
            this.parents.clear();
            return this;
        }

        public CommitBuilder noFiles() {
            this.tree.clear();
            return this;
        }

        public CommitBuilder setTopLevelTree(ObjectId treeId) {
            this.topLevelTree = treeId;
            return this;
        }

        public CommitBuilder add(String path, String content) throws Exception {
            return this.add(path, TestRepository.this.blob(content));
        }

        public CommitBuilder add(String path, final RevBlob id) throws Exception {
            return this.edit(new DirCacheEditor.PathEdit(path){

                public void apply(DirCacheEntry ent) {
                    ent.setFileMode(FileMode.REGULAR_FILE);
                    ent.setObjectId((AnyObjectId)id);
                }
            });
        }

        public CommitBuilder edit(DirCacheEditor.PathEdit edit) {
            DirCacheEditor e = this.tree.editor();
            e.add(edit);
            e.finish();
            return this;
        }

        public CommitBuilder rm(String path) {
            DirCacheEditor e = this.tree.editor();
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(path));
            e.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeleteTree(path));
            e.finish();
            return this;
        }

        public CommitBuilder message(String m) {
            this.message = m;
            return this;
        }

        public String message() {
            return this.message;
        }

        public CommitBuilder tick(int secs) {
            this.tick = secs;
            return this;
        }

        public CommitBuilder ident(PersonIdent ident) {
            this.author = ident;
            this.committer = ident;
            return this;
        }

        public CommitBuilder author(PersonIdent a) {
            this.author = a;
            return this;
        }

        public PersonIdent author() {
            return this.author;
        }

        public CommitBuilder committer(PersonIdent c) {
            this.committer = c;
            return this;
        }

        public PersonIdent committer() {
            return this.committer;
        }

        public CommitBuilder insertChangeId() {
            this.changeId = "";
            return this;
        }

        public CommitBuilder insertChangeId(String c) {
            ObjectId.fromString((String)c);
            this.changeId = c;
            return this;
        }

        public RevCommit create() throws Exception {
            if (this.self == null) {
                ObjectId commitId;
                TestRepository.this.tick(this.tick);
                org.eclipse.jgit.lib.CommitBuilder c = new org.eclipse.jgit.lib.CommitBuilder();
                c.setParentIds(this.parents);
                TestRepository.this.setAuthorAndCommitter(c);
                if (this.author != null) {
                    c.setAuthor(this.author);
                }
                if (this.committer != null) {
                    if (this.updateCommitterTime) {
                        this.committer = new PersonIdent(this.committer, TestRepository.this.getDate());
                    }
                    c.setCommitter(this.committer);
                }
                try (ObjectInserter ins = TestRepository.this.inserter;){
                    if (this.topLevelTree != null) {
                        c.setTreeId((AnyObjectId)this.topLevelTree);
                    } else {
                        c.setTreeId((AnyObjectId)this.tree.writeTree(ins));
                    }
                    this.insertChangeId(c);
                    c.setMessage(this.message);
                    commitId = ins.insert(c);
                    ins.flush();
                }
                this.self = TestRepository.this.pool.lookupCommit((AnyObjectId)commitId);
                if (this.branch != null) {
                    this.branch.update(this.self);
                }
            }
            return this.self;
        }

        private void insertChangeId(org.eclipse.jgit.lib.CommitBuilder c) throws IOException {
            if (this.changeId == null) {
                return;
            }
            int idx = ChangeIdUtil.indexOfChangeId((String)this.message, (String)"\n");
            if (idx >= 0) {
                return;
            }
            ObjectId firstParentId = null;
            if (!this.parents.isEmpty()) {
                firstParentId = (ObjectId)this.parents.get(0);
            }
            ObjectId cid = this.changeId.equals("") ? ChangeIdUtil.computeChangeId((ObjectId)c.getTreeId(), (ObjectId)firstParentId, (PersonIdent)c.getAuthor(), (PersonIdent)c.getCommitter(), (String)this.message) : ObjectId.fromString((String)this.changeId);
            this.message = ChangeIdUtil.insertId((String)this.message, (ObjectId)cid);
            if (cid != null) {
                this.message = this.message.replaceAll("\nChange-Id: I" + ObjectId.zeroId().getName() + "\n", "\nChange-Id: I" + cid.getName() + "\n");
            }
        }

        public CommitBuilder child() throws Exception {
            return new CommitBuilder(this);
        }
    }
}

