/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.ServerKeyLookup;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.proxy.StatefulProxyConnector;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.util.StringUtils;

public class JGitClientSession
extends ClientSessionImpl {
    public static final AttributeRepository.AttributeKey<Supplier<KeyPasswordProvider>> KEY_PASSWORD_PROVIDER_FACTORY = new AttributeRepository.AttributeKey();
    private static final int DEFAULT_MAX_IDENTIFICATION_SIZE = 65536;
    private static final AttributeRepository.AttributeKey<Boolean> INITIAL_KEX_DONE = new AttributeRepository.AttributeKey();
    private HostConfigEntry hostConfig;
    private CredentialsProvider credentialsProvider;
    private volatile StatefulProxyConnector proxyHandler;

    public JGitClientSession(ClientFactoryManager manager, IoSession session) throws Exception {
        super(manager, session);
    }

    public HostConfigEntry getHostConfigEntry() {
        return this.hostConfig;
    }

    public void setHostConfigEntry(HostConfigEntry hostConfig) {
        this.hostConfig = hostConfig;
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.credentialsProvider = provider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setProxyHandler(StatefulProxyConnector handler) {
        this.proxyHandler = handler;
    }

    protected IoWriteFuture sendIdentification(String ident, List<String> extraLines) throws Exception {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            proxy.runWhenDone(() -> {
                JGitClientSession.super.sendIdentification(ident, extraLines);
                return null;
            });
            return null;
        }
        return super.sendIdentification(ident, extraLines);
    }

    protected byte[] sendKexInit() throws Exception {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            proxy.runWhenDone(() -> {
                JGitClientSession.super.sendKexInit();
                return null;
            });
            return null;
        }
        return super.sendKexInit();
    }

    public void messageReceived(Readable buffer) throws Exception {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            proxy.messageReceived(this.getIoSession(), buffer);
        } else {
            super.messageReceived(buffer);
        }
    }

    Set<String> getAllAvailableSignatureAlgorithms() {
        HashSet<String> allAvailable = new HashSet<String>();
        BuiltinSignatures.VALUES.forEach(s -> {
            boolean bl = allAvailable.add(s.getName());
        });
        BuiltinSignatures.getRegisteredExtensions().forEach(s -> {
            boolean bl = allAvailable.add(s.getName());
        });
        return allAvailable;
    }

    private void setNewFactories(Collection<String> defaultFactories, Collection<String> finalFactories) {
        LinkedHashSet<String> resultSet = new LinkedHashSet<String>(defaultFactories);
        resultSet.addAll(finalFactories);
        this.setSignatureFactoriesNames(resultSet);
    }

    protected String resolveAvailableSignaturesProposal(FactoryManager manager) {
        ServerKeyVerifier verifier;
        List defaultSignatures = this.getSignatureFactoriesNames();
        HostConfigEntry config = (HostConfigEntry)this.resolveAttribute(JGitSshClient.HOST_CONFIG_ENTRY);
        String algorithms = config.getProperty("HostKeyAlgorithms");
        if (!StringUtils.isEmptyOrNull((String)algorithms)) {
            List<String> result = this.modifyAlgorithmList(defaultSignatures, this.getAllAvailableSignatureAlgorithms(), algorithms, "HostKeyAlgorithms");
            if (!result.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("HostKeyAlgorithms " + String.valueOf(result));
                }
                this.setNewFactories(defaultSignatures, result);
                return String.join((CharSequence)",", result);
            }
            this.log.warn(MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "HostKeyAlgorithms", algorithms));
        }
        if ((verifier = this.getServerKeyVerifier()) instanceof ServerKeyLookup) {
            SocketAddress remoteAddress = this.resolvePeerAddress((SocketAddress)this.resolveAttribute(JGitSshClient.ORIGINAL_REMOTE_ADDRESS));
            List<PublicKey> allKnownKeys = ((ServerKeyLookup)verifier).lookup((ClientSession)this, remoteAddress);
            LinkedHashSet<String> reordered = new LinkedHashSet<String>();
            for (PublicKey key : allKnownKeys) {
                String keyType;
                if (key == null || (keyType = KeyUtils.getKeyType((Key)key)) == null) continue;
                if ("ssh-rsa".equals(keyType)) {
                    reordered.add("rsa-sha2-512");
                    reordered.add("rsa-sha2-256");
                }
                reordered.add(keyType);
            }
            reordered.addAll(defaultSignatures);
            if (this.log.isDebugEnabled()) {
                this.log.debug("HostKeyAlgorithms " + String.valueOf(reordered));
            }
            if (reordered.size() > defaultSignatures.size()) {
                this.setNewFactories(defaultSignatures, reordered);
            }
            return String.join((CharSequence)",", reordered);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("HostKeyAlgorithms " + String.valueOf(defaultSignatures));
        }
        return String.join((CharSequence)",", defaultSignatures);
    }

    private List<String> determineKexProposal() {
        List kexFactories = this.getKeyExchangeFactories();
        List defaultKexMethods = NamedResource.getNameList((Collection)kexFactories);
        HostConfigEntry config = (HostConfigEntry)this.resolveAttribute(JGitSshClient.HOST_CONFIG_ENTRY);
        String algorithms = config.getProperty("KexAlgorithms");
        if (!StringUtils.isEmptyOrNull((String)algorithms)) {
            HashSet<String> allAvailable = new HashSet<String>();
            BuiltinDHFactories.VALUES.forEach(s -> {
                boolean bl = allAvailable.add(s.getName());
            });
            BuiltinDHFactories.getRegisteredExtensions().forEach(s -> {
                boolean bl = allAvailable.add(s.getName());
            });
            List<String> result = this.modifyAlgorithmList(defaultKexMethods, allAvailable, algorithms, "KexAlgorithms");
            if (!result.isEmpty()) {
                HashSet configuredKexMethods = new HashSet(defaultKexMethods);
                ArrayList newKexFactories = new ArrayList();
                result.forEach(name -> {
                    if (!configuredKexMethods.contains(name)) {
                        DHFactory factory = BuiltinDHFactories.resolveFactory((String)name);
                        if (factory == null) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("determineKexProposal({}) unknown KEX algorithm {} ignored", (Object)this, name);
                            }
                        } else {
                            newKexFactories.add((KeyExchangeFactory)ClientBuilder.DH2KEX.apply(factory));
                        }
                    }
                });
                if (!newKexFactories.isEmpty()) {
                    newKexFactories.addAll(kexFactories);
                    this.setKeyExchangeFactories(newKexFactories);
                }
                return result;
            }
            this.log.warn(MessageFormat.format(SshdText.get().configNoKnownAlgorithms, "KexAlgorithms", algorithms));
        }
        return defaultKexMethods;
    }

    protected String resolveSessionKexProposal(String hostKeyTypes) throws IOException {
        Object kexMethods = String.join((CharSequence)",", this.determineKexProposal());
        Boolean isRekey = this.getAttribute(INITIAL_KEX_DONE);
        if (isRekey == null || !isRekey.booleanValue()) {
            KexExtensionHandler extHandler = this.getKexExtensionHandler();
            if (extHandler != null && extHandler.isKexExtensionsAvailable((Session)this, KexExtensionHandler.AvailabilityPhase.PROPOSAL)) {
                kexMethods = ((String)kexMethods).isEmpty() ? "ext-info-c" : (String)kexMethods + ",ext-info-c";
            }
            this.setAttribute(INITIAL_KEX_DONE, Boolean.TRUE);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("KexAlgorithms " + (String)kexMethods);
        }
        return kexMethods;
    }

    public List<String> modifyAlgorithmList(List<String> defaultList, Set<String> allAvailable, String fromConfig, String overrideKey) {
        LinkedHashSet<String> defaults = new LinkedHashSet<String>();
        defaults.addAll(defaultList);
        switch (fromConfig.charAt(0)) {
            case '+': {
                List<String> newSignatures = this.filteredList(allAvailable, overrideKey, fromConfig.substring(1));
                defaults.addAll(newSignatures);
                return new ArrayList<String>(defaults);
            }
            case '-': {
                this.removeFromList(defaults, overrideKey, fromConfig.substring(1));
                return new ArrayList<String>(defaults);
            }
            case '^': {
                List<String> allSignatures = this.filteredList(allAvailable, overrideKey, fromConfig.substring(1));
                HashSet<String> atFront = new HashSet<String>(allSignatures);
                for (String sig : defaults) {
                    if (atFront.contains(sig)) continue;
                    allSignatures.add(sig);
                }
                return allSignatures;
            }
        }
        return this.filteredList(allAvailable, overrideKey, fromConfig);
    }

    private void removeFromList(Set<String> current, String key, String patterns) {
        String[] stringArray = patterns.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String toRemove = stringArray[n2];
            if (toRemove.indexOf(42) < 0 && toRemove.indexOf(63) < 0) {
                current.remove(toRemove);
            } else {
                try {
                    FileNameMatcher matcher = new FileNameMatcher(toRemove, null);
                    Iterator<String> i = current.iterator();
                    while (i.hasNext()) {
                        matcher.reset();
                        matcher.append(i.next());
                        if (!matcher.isMatch()) continue;
                        i.remove();
                    }
                }
                catch (InvalidPatternException e) {
                    this.log.warn(MessageFormat.format(SshdText.get().configInvalidPattern, key, toRemove));
                }
            }
            ++n2;
        }
    }

    private List<String> filteredList(Set<String> known, String key, String values) {
        ArrayList<String> newNames = new ArrayList<String>();
        String[] stringArray = values.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String newValue = stringArray[n2];
            if (known.contains(newValue)) {
                newNames.add(newValue);
            } else {
                this.log.warn(MessageFormat.format(SshdText.get().configUnknownAlgorithm, new Object[]{this, newValue, key, values}));
            }
            ++n2;
        }
        return newNames;
    }

    protected List<String> doReadIdentification(Buffer buffer, boolean server) throws StreamCorruptedException {
        int maxIdentSize;
        if (server) {
            throw new IllegalStateException("doReadIdentification of client called with server=true");
        }
        Integer maxIdentLength = CoreModuleProperties.MAX_IDENTIFICATION_SIZE.get((PropertyResolver)this).orElse(null);
        if (maxIdentLength == null || maxIdentLength < 65536) {
            maxIdentSize = 65536;
            CoreModuleProperties.MAX_IDENTIFICATION_SIZE.set((PropertyResolver)this, (Object)maxIdentSize);
        } else {
            maxIdentSize = maxIdentLength;
        }
        int current = buffer.rpos();
        int end = current + buffer.available();
        if (current >= end) {
            return null;
        }
        byte[] raw = buffer.array();
        ArrayList<String> ident = new ArrayList<String>();
        int start = current;
        boolean hasNul = false;
        int i = current;
        while (i < end) {
            switch (raw[i]) {
                case 0: {
                    hasNul = true;
                    break;
                }
                case 10: {
                    int eol = 1;
                    if (i > start && raw[i - 1] == 13) {
                        ++eol;
                    }
                    String line = new String(raw, start, i + 1 - eol - start, StandardCharsets.UTF_8);
                    start = i + 1;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(MessageFormat.format("doReadIdentification({0}) line: ", new Object[]{this}) + JGitClientSession.escapeControls(line));
                    }
                    ident.add(line);
                    if (line.startsWith("SSH-")) {
                        if (hasNul) {
                            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().serverIdWithNul, JGitClientSession.escapeControls(line)));
                        }
                        if (line.length() + eol > 255) {
                            throw new StreamCorruptedException(MessageFormat.format(SshdText.get().serverIdTooLong, JGitClientSession.escapeControls(line)));
                        }
                        buffer.rpos(start);
                        return ident;
                    }
                    hasNul = false;
                    break;
                }
            }
            if (i - current + 1 >= maxIdentSize) {
                String msg = MessageFormat.format(SshdText.get().serverIdNotReceived, Integer.toString(maxIdentSize));
                if (this.log.isDebugEnabled()) {
                    this.log.debug(msg);
                    this.log.debug(buffer.toHex());
                }
                throw new StreamCorruptedException(msg);
            }
            ++i;
        }
        return null;
    }

    private static String escapeControls(String s) {
        StringBuilder b = new StringBuilder();
        int l = s.length();
        int i = 0;
        while (i < l) {
            char ch = s.charAt(i);
            if (Character.isISOControl(ch)) {
                b.append(ch <= '\u000f' ? "\\u000" : "\\u00").append(Integer.toHexString(ch));
            } else {
                b.append(ch);
            }
            ++i;
        }
        return b.toString();
    }

    public <T> T getAttribute(AttributeRepository.AttributeKey<T> key) {
        Object obj;
        IoSession ioSession;
        Object value = super.getAttribute(key);
        if (value == null && (ioSession = this.getIoSession()) != null && (obj = ioSession.getAttribute(AttributeRepository.class)) instanceof AttributeRepository) {
            AttributeRepository sessionAttributes = (AttributeRepository)obj;
            value = sessionAttributes.resolveAttribute(key);
        }
        return (T)value;
    }

    public PropertyResolver getParentPropertyResolver() {
        Object obj;
        IoSession ioSession = this.getIoSession();
        if (ioSession != null && (obj = ioSession.getAttribute(AttributeRepository.class)) instanceof PropertyResolver) {
            return (PropertyResolver)obj;
        }
        return super.getParentPropertyResolver();
    }

    public static class ChainingAttributes
    implements AttributeRepository {
        private final AttributeRepository delegate;
        private final AttributeRepository parent;

        public ChainingAttributes(AttributeRepository self, AttributeRepository parent) {
            this.delegate = self;
            this.parent = parent;
        }

        public int getAttributesCount() {
            return this.delegate.getAttributesCount();
        }

        public <T> T getAttribute(AttributeRepository.AttributeKey<T> key) {
            return (T)this.delegate.getAttribute(Objects.requireNonNull(key));
        }

        public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
            return this.delegate.attributeKeys();
        }

        public <T> T resolveAttribute(AttributeRepository.AttributeKey<T> key) {
            T value = this.getAttribute(Objects.requireNonNull(key));
            if (value == null) {
                return (T)this.parent.getAttribute(key);
            }
            return value;
        }
    }

    public static class SessionAttributes
    extends ChainingAttributes
    implements PropertyResolver {
        public static final AttributeRepository.AttributeKey<Map<String, Object>> PROPERTIES = new AttributeRepository.AttributeKey();
        private final PropertyResolver parentProperties;

        public SessionAttributes(AttributeRepository self, AttributeRepository parent, PropertyResolver parentProperties) {
            super(self, parent);
            this.parentProperties = parentProperties;
        }

        public PropertyResolver getParentPropertyResolver() {
            return this.parentProperties;
        }

        public Map<String, Object> getProperties() {
            Map<String, Object> props = this.getAttribute(PROPERTIES);
            return props == null ? Collections.emptyMap() : props;
        }
    }
}

