/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.NoMergeBaseException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveMerger
extends ResolveMerger {
    public final int MAX_BASES = 200;
    private PersonIdent ident = new PersonIdent(this.db);

    protected RecursiveMerger(Repository local, boolean inCore) {
        super(local, inCore);
    }

    protected RecursiveMerger(Repository local) {
        this(local, false);
    }

    @Override
    protected RevCommit getBaseCommit(RevCommit a, RevCommit b) throws IncorrectObjectTypeException, IOException {
        return this.getBaseCommit(a, b, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RevCommit getBaseCommit(RevCommit a, RevCommit b, int callDepth) throws IOException {
        RevCommit c;
        ArrayList<RevCommit> baseCommits = new ArrayList<RevCommit>();
        this.walk.reset();
        this.walk.setRevFilter(RevFilter.MERGE_BASE);
        this.walk.markStart(a);
        this.walk.markStart(b);
        while ((c = this.walk.next()) != null) {
            baseCommits.add(c);
        }
        if (baseCommits.isEmpty()) {
            return null;
        }
        if (baseCommits.size() == 1) {
            return (RevCommit)baseCommits.get(0);
        }
        if (baseCommits.size() >= 200) {
            throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.TOO_MANY_MERGE_BASES, MessageFormat.format(JGitText.get().mergeRecursiveTooManyMergeBasesFor, 200, a.name(), b.name(), baseCommits.size()));
        }
        RevCommit currentBase = (RevCommit)baseCommits.get(0);
        DirCache oldDircache = this.dircache;
        boolean oldIncore = this.inCore;
        WorkingTreeIterator oldWTreeIt = this.workingTreeIterator;
        this.workingTreeIterator = null;
        try {
            this.dircache = this.dircacheFromTree(currentBase.getTree());
            this.inCore = true;
            ArrayList<RevCommit> parents = new ArrayList<RevCommit>();
            parents.add(currentBase);
            for (int commitIdx = 1; commitIdx < baseCommits.size(); ++commitIdx) {
                RevCommit nextBase = (RevCommit)baseCommits.get(commitIdx);
                if (commitIdx >= 200) {
                    throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.TOO_MANY_MERGE_BASES, MessageFormat.format(JGitText.get().mergeRecursiveTooManyMergeBasesFor, 200, a.name(), b.name(), baseCommits.size()));
                }
                parents.add(nextBase);
                if (!this.mergeTrees(this.openTree(this.getBaseCommit(currentBase, nextBase, callDepth + 1).getTree()), currentBase.getTree(), nextBase.getTree())) {
                    throw new NoMergeBaseException(NoMergeBaseException.MergeBaseFailureReason.CONFLICTS_DURING_MERGE_BASE_CALCULATION, MessageFormat.format(JGitText.get().mergeRecursiveTooManyMergeBasesFor, 200, a.name(), b.name(), baseCommits.size()));
                }
                currentBase = this.createCommitForTree(this.resultTree, parents);
            }
            Object var14_13 = null;
            this.inCore = oldIncore;
            this.dircache = oldDircache;
            this.workingTreeIterator = oldWTreeIt;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.inCore = oldIncore;
            this.dircache = oldDircache;
            this.workingTreeIterator = oldWTreeIt;
            throw throwable;
        }
        return currentBase;
    }

    private RevCommit createCommitForTree(ObjectId tree, List<RevCommit> parents) throws IOException {
        CommitBuilder c = new CommitBuilder();
        c.setParentIds(parents);
        c.setTreeId(tree);
        c.setAuthor(this.ident);
        c.setCommitter(this.ident);
        ObjectInserter odi = this.db.newObjectInserter();
        ObjectId newCommitId = odi.insert(c);
        odi.flush();
        RevCommit ret = this.walk.lookupCommit(newCommitId);
        this.walk.parseHeaders(ret);
        return ret;
    }

    private DirCache dircacheFromTree(ObjectId treeId) throws IOException {
        DirCache ret = DirCache.newInCore();
        DirCacheBuilder builder = ret.builder();
        TreeWalk tw = new TreeWalk(this.db);
        tw.addTree(treeId);
        tw.setRecursive(true);
        while (tw.next()) {
            DirCacheEntry e = new DirCacheEntry(tw.getRawPath());
            e.setFileMode(tw.getFileMode(0));
            e.setObjectId(tw.getObjectId(0));
            builder.add(e);
        }
        builder.finish();
        return ret;
    }
}

