/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.FS;

public class FileUtils {
    public static final int NONE = 0;
    public static final int RECURSIVE = 1;
    public static final int RETRY = 2;
    public static final int SKIP_MISSING = 4;
    public static final int IGNORE_ERRORS = 8;
    public static final int EMPTY_DIRECTORIES_ONLY = 16;

    public static void delete(File f) throws IOException {
        FileUtils.delete(f, 0);
    }

    public static void delete(File f, int options) throws IOException {
        File[] items;
        FS fs = FS.DETECTED;
        if ((options & 4) != 0 && !fs.exists(f)) {
            return;
        }
        if ((options & 1) != 0 && fs.isDirectory(f) && (items = f.listFiles()) != null) {
            ArrayList<File> files = new ArrayList<File>();
            ArrayList<File> dirs = new ArrayList<File>();
            for (File c : items) {
                if (c.isFile()) {
                    files.add(c);
                    continue;
                }
                dirs.add(c);
            }
            for (File file : files) {
                FileUtils.delete(file, options);
            }
            for (File d : dirs) {
                FileUtils.delete(d, options);
            }
        }
        boolean delete = false;
        if ((options & 0x10) != 0) {
            if (f.isDirectory()) {
                delete = true;
            } else if ((options & 8) == 0) {
                throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, f.getAbsolutePath()));
            }
        } else {
            delete = true;
        }
        if (delete && !f.delete()) {
            if ((options & 2) != 0 && fs.exists(f)) {
                for (int i = 1; i < 10; ++i) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!f.delete()) continue;
                    return;
                }
            }
            if ((options & 8) == 0) {
                throw new IOException(MessageFormat.format(JGitText.get().deleteFileFailed, f.getAbsolutePath()));
            }
        }
    }

    public static void rename(File src, File dst) throws IOException {
        int attempts;
        int n = attempts = FS.DETECTED.retryFailedLockFileCommit() ? 10 : 1;
        while (--attempts >= 0) {
            if (src.renameTo(dst)) {
                return;
            }
            try {
                if (!dst.delete()) {
                    FileUtils.delete(dst, 17);
                }
                if (src.renameTo(dst)) {
                    return;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, src.getAbsolutePath(), dst.getAbsolutePath()));
            }
        }
        throw new IOException(MessageFormat.format(JGitText.get().renameFileFailed, src.getAbsolutePath(), dst.getAbsolutePath()));
    }

    public static void mkdir(File d) throws IOException {
        FileUtils.mkdir(d, false);
    }

    public static void mkdir(File d, boolean skipExisting) throws IOException {
        if (!d.mkdir()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirFailed, d.getAbsolutePath()));
        }
    }

    public static void mkdirs(File d) throws IOException {
        FileUtils.mkdirs(d, false);
    }

    public static void mkdirs(File d, boolean skipExisting) throws IOException {
        if (!d.mkdirs()) {
            if (skipExisting && d.isDirectory()) {
                return;
            }
            throw new IOException(MessageFormat.format(JGitText.get().mkDirsFailed, d.getAbsolutePath()));
        }
    }

    public static void createNewFile(File f) throws IOException {
        if (!f.createNewFile()) {
            throw new IOException(MessageFormat.format(JGitText.get().createNewFileFailed, f));
        }
    }

    public static void createSymLink(File path, String target) throws IOException {
        FS.DETECTED.createSymLink(path, target);
    }

    public static String readSymLink(File path) throws IOException {
        return FS.DETECTED.readSymLink(path);
    }
}

