/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

final class PackWriterBitmapWalker {
    private final ObjectWalk walker;
    private final BitmapIndex bitmapIndex;
    private final ProgressMonitor pm;

    PackWriterBitmapWalker(ObjectWalk walker, BitmapIndex bitmapIndex, ProgressMonitor pm) {
        this.walker = walker;
        this.bitmapIndex = bitmapIndex;
        this.pm = pm == null ? NullProgressMonitor.INSTANCE : pm;
    }

    BitmapIndex.BitmapBuilder findObjects(Set<? extends ObjectId> start, BitmapIndex.BitmapBuilder seen, boolean ignoreMissingStart) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        BitmapIndex.BitmapBuilder bitmapResult = this.bitmapIndex.newBitmapBuilder();
        for (ObjectId objectId : start) {
            BitmapIndex.Bitmap bitmap = this.bitmapIndex.getBitmap(objectId);
            if (bitmap == null) continue;
            bitmapResult.or(bitmap);
        }
        boolean marked = false;
        for (ObjectId objectId : start) {
            try {
                if (bitmapResult.contains(objectId)) continue;
                this.walker.markStart(this.walker.parseAny(objectId));
                marked = true;
            }
            catch (MissingObjectException e) {
                if (ignoreMissingStart) continue;
                throw e;
            }
        }
        if (marked) {
            RevObject revObject;
            this.walker.setRevFilter(PackWriterBitmapWalker.newRevFilter(seen, bitmapResult));
            while (this.walker.next() != null) {
                this.pm.update(1);
            }
            while ((revObject = this.walker.nextObject()) != null) {
                bitmapResult.add(revObject, revObject.getType());
                this.pm.update(1);
            }
        }
        return bitmapResult;
    }

    void reset() {
        this.walker.reset();
    }

    static RevFilter newRevFilter(final BitmapIndex.BitmapBuilder seen, final BitmapIndex.BitmapBuilder bitmapResult) {
        if (seen != null) {
            return new BitmapRevFilter(){

                @Override
                protected boolean load(RevCommit cmit) {
                    if (seen.contains(cmit)) {
                        return false;
                    }
                    return bitmapResult.add(cmit, 1);
                }
            };
        }
        return new BitmapRevFilter(){

            @Override
            protected boolean load(RevCommit cmit) {
                return bitmapResult.add(cmit, 1);
            }
        };
    }

    static abstract class BitmapRevFilter
    extends RevFilter {
        BitmapRevFilter() {
        }

        protected abstract boolean load(RevCommit var1);

        @Override
        public final boolean include(RevWalk walker, RevCommit cmit) {
            if (this.load(cmit)) {
                return true;
            }
            for (RevCommit p : cmit.getParents()) {
                p.add(RevFlag.SEEN);
            }
            return false;
        }

        @Override
        public final RevFilter clone() {
            return this;
        }

        @Override
        public final boolean requiresCommitBody() {
            return false;
        }
    }
}

