/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.api.assembly;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.AssemblyFile;
import org.eclipse.jkube.kit.common.AssemblyFileEntry;
import org.eclipse.jkube.kit.common.AssemblyFileSet;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.DockerFileBuilder;

class AssemblyConfigurationUtils {
    private static final String LINUX_FILE_SEPARATOR = "/";
    private static final String DEFAULT_NAME = "maven";

    private AssemblyConfigurationUtils() {
    }

    @Nonnull
    static AssemblyConfiguration getAssemblyConfigurationOrCreateDefault(@Nullable BuildConfiguration buildConfiguration) {
        String name;
        AssemblyConfiguration ac = Optional.ofNullable(buildConfiguration).map(BuildConfiguration::getAssembly).orElse(AssemblyConfiguration.builder().build());
        AssemblyConfiguration.AssemblyConfigurationBuilder builder = ac.toBuilder();
        if (StringUtils.isBlank((CharSequence)ac.getName())) {
            builder.name(DEFAULT_NAME);
            name = DEFAULT_NAME;
        } else {
            name = ac.getName();
        }
        if (StringUtils.isBlank((CharSequence)ac.getTargetDir())) {
            builder.targetDir(LINUX_FILE_SEPARATOR.concat(name));
        }
        return builder.build();
    }

    @Nonnull
    static List<AssemblyFileSet> getJKubeAssemblyFileSets(@Nullable Assembly assembly) {
        return Optional.ofNullable(assembly).map(Assembly::getFileSets).orElse(Collections.emptyList());
    }

    @Nonnull
    static List<AssemblyFile> getJKubeAssemblyFiles(@Nullable Assembly assembly) {
        return Optional.ofNullable(assembly).map(Assembly::getFiles).orElse(Collections.emptyList());
    }

    @Nonnull
    static DockerFileBuilder createDockerFileBuilder(BuildConfiguration buildConfig, AssemblyConfiguration assemblyConfig, Map<Assembly, List<AssemblyFileEntry>> layers) {
        DockerFileBuilder builder = new DockerFileBuilder().baseImage(buildConfig.getFrom()).env(buildConfig.getEnv()).labels(buildConfig.getLabels()).expose(buildConfig.getPorts()).run(buildConfig.getRunCmds()).volumes(buildConfig.getVolumes()).user(buildConfig.getUser());
        Optional.ofNullable(buildConfig.getMaintainer()).ifPresent(arg_0 -> ((DockerFileBuilder)builder).maintainer(arg_0));
        Optional.ofNullable(buildConfig.getWorkdir()).ifPresent(arg_0 -> ((DockerFileBuilder)builder).workdir(arg_0));
        Optional.ofNullable(buildConfig.getHealthCheck()).ifPresent(arg_0 -> ((DockerFileBuilder)builder).healthCheck(arg_0));
        Optional.ofNullable(buildConfig.getCmd()).ifPresent(arg_0 -> ((DockerFileBuilder)builder).cmd(arg_0));
        Optional.ofNullable(buildConfig.getEntryPoint()).ifPresent(arg_0 -> ((DockerFileBuilder)builder).entryPoint(arg_0));
        if (assemblyConfig != null) {
            builder.basedir(assemblyConfig.getTargetDir()).assemblyUser(assemblyConfig.getUser()).exportTargetDir(assemblyConfig.getExportTargetDir());
            if (layers.isEmpty()) {
                builder.add(assemblyConfig.getTargetDir(), "");
            }
            List effectiveLayers = layers.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList());
            for (Assembly layer : effectiveLayers) {
                if (StringUtils.isNotBlank((CharSequence)layer.getId())) {
                    builder.add(StringUtils.prependIfMissing((String)layer.getId(), (CharSequence)LINUX_FILE_SEPARATOR, (CharSequence[])new CharSequence[0]) + assemblyConfig.getTargetDir(), "");
                    continue;
                }
                builder.add(assemblyConfig.getTargetDir(), "");
            }
        } else {
            builder.exportTargetDir(Boolean.valueOf(false));
        }
        if (buildConfig.optimise()) {
            builder.optimise();
        }
        return builder;
    }
}

