/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util.okhttp;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;

public class BufferStringReader
extends StringReader {
    private static final int READ_AHEAD_LIMIT = Integer.MAX_VALUE;

    public BufferStringReader(String s) {
        super(s);
    }

    public boolean exhausted() throws IOException {
        this.mark(Integer.MAX_VALUE);
        int charRead = this.read();
        boolean exhausted = true;
        if (charRead != -1) {
            exhausted = false;
            this.reset();
        }
        return exhausted;
    }

    public char readByte() throws IOException {
        return this.fetchCharAt(0L, false);
    }

    public char getByte() throws IOException {
        return this.fetchCharAt(0L, true);
    }

    public char getByte(long index) throws IOException {
        return this.fetchCharAt(index, true);
    }

    public int indexOfElement(List<Character> sequences) throws IOException {
        this.mark(Integer.MAX_VALUE);
        String remainingString = this.readUtf8(this.size());
        int foundIndex = -1;
        int nearestIndex = Integer.MAX_VALUE;
        for (Character ch : sequences) {
            int indexOfCh = remainingString.indexOf(ch.charValue());
            if (indexOfCh < 0) continue;
            foundIndex = indexOfCh;
            nearestIndex = Math.min(foundIndex, nearestIndex);
        }
        this.reset();
        return foundIndex != -1 ? nearestIndex : foundIndex;
    }

    public int size() throws IOException {
        this.mark(Integer.MAX_VALUE);
        int size = 0;
        int charRead = 0;
        while (charRead != -1) {
            charRead = this.read();
            if (charRead == -1) continue;
            ++size;
        }
        this.reset();
        return size;
    }

    public String readUtf8(long size) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.mark(Integer.MAX_VALUE);
        int readChars = 0;
        int charRead = 0;
        while (charRead != -1 && (long)readChars < size) {
            charRead = this.read();
            if (charRead == -1) continue;
            char ch = (char)charRead;
            stringBuilder.append(ch);
            ++readChars;
        }
        return stringBuilder.toString();
    }

    private char fetchCharAt(long index, boolean resetMarkAfterRead) throws IOException {
        if (resetMarkAfterRead) {
            this.mark(Integer.MAX_VALUE);
        }
        long charRead = 0L;
        for (long count = 0L; count < index + 1L && charRead != -1L; ++count) {
            charRead = this.read();
        }
        if (resetMarkAfterRead) {
            this.reset();
        }
        return (char)charRead;
    }
}

