/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.config.service;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.KubernetesHelper;
import org.eclipse.jkube.kit.config.service.PodLogService;
import org.eclipse.jkube.kit.config.service.kubernetes.KubernetesClientUtil;

public class PodLogEventHandler
implements ResourceEventHandler<Pod>,
AutoCloseable {
    private final PodLogService.PodLogServiceContext context;
    private final KubernetesClient kubernetesClient;
    private final String onExitOperation;
    private final boolean followLog;
    private final CompletableFuture<Void> logsRetrieved;
    private final ConcurrentMap<String, Pod> activePods;
    private final AtomicReference<LogWatchLogger> currentLogWatch;

    public PodLogEventHandler(PodLogService.PodLogServiceContext context, KubernetesClient kubernetesClient, String onExitOperation, boolean followLog) {
        this.context = context;
        this.kubernetesClient = kubernetesClient;
        this.onExitOperation = onExitOperation;
        this.followLog = followLog;
        this.activePods = new ConcurrentHashMap<String, Pod>();
        this.currentLogWatch = new AtomicReference();
        this.logsRetrieved = new CompletableFuture();
    }

    public void onAdd(Pod pod) {
        this.activePods.put(KubernetesHelper.getName((HasMetadata)pod), pod);
        PodLogEventHandler.logStatus(this.context.getNewPodLog(), pod);
        this.podLog();
    }

    public void onUpdate(Pod oldPod, Pod newPod) {
        this.activePods.put(KubernetesHelper.getName((HasMetadata)newPod), newPod);
        if (!Objects.equals(this.getCurrentlyLoggedPodName(), KubernetesHelper.getName((HasMetadata)newPod))) {
            PodLogEventHandler.logStatus(Objects.equals(KubernetesHelper.getName((HasMetadata)this.mostRecentPod()), KubernetesHelper.getName((HasMetadata)newPod)) ? this.context.getNewPodLog() : this.context.getOldPodLog(), newPod);
        }
        this.podLog();
    }

    public void onDelete(Pod pod, boolean deletedFinalStateUnknown) {
        this.activePods.remove(KubernetesHelper.getName((HasMetadata)pod));
        if (Objects.equals(this.getCurrentlyLoggedPodName(), KubernetesHelper.getName((HasMetadata)pod))) {
            this.context.getLog().info("Closing log watcher for %s (Deleted)", new Object[]{this.getCurrentlyLoggedPodName()});
            ((LogWatchLogger)this.currentLogWatch.getAndSet(null)).close();
        }
        PodLogEventHandler.logStatus(this.context.getOldPodLog(), pod, ": Pod Deleted");
        this.podLog();
    }

    @Override
    public void close() {
        if (this.currentLogWatch.get() != null) {
            this.currentLogWatch.get().close();
        }
    }

    public final String getCurrentlyLoggedPodName() {
        return this.currentLogWatch.get() != null ? this.currentLogWatch.get().podName : null;
    }

    public final CompletableFuture<Void> getLogsRetrieved() {
        return this.logsRetrieved;
    }

    private void podLog() {
        Loggable loggable;
        String containerName;
        List containers;
        Pod pod = this.mostRecentPod();
        String podName = KubernetesHelper.getName((HasMetadata)pod);
        if (pod == null || !KubernetesHelper.isPodRunning((Pod)pod) || Objects.equals(this.getCurrentlyLoggedPodName(), podName)) {
            return;
        }
        if (this.currentLogWatch.get() != null) {
            this.context.getLog().info("Closing log watcher for %s as now watching %s", new Object[]{this.getCurrentlyLoggedPodName(), podName});
            ((LogWatchLogger)this.currentLogWatch.getAndSet(null)).close();
        }
        if ((containers = KubernetesHelper.getContainers((Pod)pod)).size() < 2) {
            containerName = containers.isEmpty() ? null : ((Container)containers.iterator().next()).getName();
            loggable = (Loggable)this.kubernetesClient.pods().withName(podName);
        } else {
            containerName = this.getLogContainerName(containers);
            loggable = (Loggable)((PodResource)this.kubernetesClient.pods().withName(podName)).inContainer((Object)containerName);
        }
        if (this.followLog) {
            this.currentLogWatch.set(this.watchLog(loggable, podName, containerName));
        } else {
            this.printLog(loggable, podName, containerName);
        }
    }

    private LogWatchLogger watchLog(Loggable loggable, String podName, String containerName) {
        this.context.getNewPodLog().info("Tailing log of pod: " + podName + PodLogEventHandler.containerNameMessage(containerName), new Object[0]);
        this.context.getNewPodLog().info("Press Ctrl-C to " + this.computeCtrlCMessage(), new Object[0]);
        this.context.getNewPodLog().info("", new Object[0]);
        LogWatch logWatch = loggable.watchLog();
        CompletableFuture asyncLogger = KubernetesHelper.printLogsAsync((LogWatch)logWatch, line -> this.context.getLog().info("[[s]]%s", new Object[]{line}));
        asyncLogger.whenComplete((v, t) -> {
            if (t != null) {
                this.context.getLog().error("Failed to read log of Pod %s: %s", new Object[]{podName, t});
            }
        });
        return new LogWatchLogger(logWatch, podName, asyncLogger);
    }

    private void printLog(Loggable loggable, String podName, String containerName) {
        String logText = loggable.getLog();
        if (logText != null) {
            String[] lines = logText.split("\n");
            this.context.getLog().info("Log of pod: %s%s", new Object[]{podName, PodLogEventHandler.containerNameMessage(containerName)});
            this.context.getLog().info("", new Object[0]);
            for (String line : lines) {
                this.context.getLog().info("[[s]]%s", new Object[]{line});
            }
        }
        this.logsRetrieved.complete(null);
    }

    private Pod mostRecentPod() {
        return KubernetesHelper.getNewestPod(this.activePods.values());
    }

    private String getLogContainerName(List<Container> containers) {
        if (StringUtils.isNotBlank((CharSequence)this.context.getLogContainerName())) {
            for (Container container : containers) {
                if (!Objects.equals(this.context.getLogContainerName(), container.getName())) continue;
                return this.context.getLogContainerName();
            }
            this.context.getLog().error("log container name %s does not exist in pod!! Did you set the correct value for property 'jkube.log.container'", new Object[]{this.context.getLogContainerName()});
        }
        return containers.get(0).getName();
    }

    private String computeCtrlCMessage() {
        if (StringUtils.isNotBlank((CharSequence)this.onExitOperation)) {
            if (this.onExitOperation.toLowerCase(Locale.ROOT).equals("undeploy")) {
                return "undeploy the app";
            }
            if (this.onExitOperation.toLowerCase(Locale.ROOT).equals("stop")) {
                return "scale down the app and stop tailing the log";
            }
        }
        return "stop tailing the log";
    }

    private static String containerNameMessage(String containerName) {
        if (StringUtils.isNotBlank((CharSequence)containerName)) {
            return " container: " + containerName;
        }
        return "";
    }

    private static void logStatus(KitLogger logger, Pod pod) {
        PodLogEventHandler.logStatus(logger, pod, "");
    }

    private static void logStatus(KitLogger logger, Pod pod, String postfix) {
        logger.info("%s status: %s%s", new Object[]{KubernetesHelper.getName((HasMetadata)pod), KubernetesClientUtil.getPodStatusDescription(pod), postfix});
    }

    private static final class LogWatchLogger
    implements AutoCloseable {
        private final LogWatch logWatch;
        private final String podName;
        private final CompletableFuture<Void> asyncLogger;

        public LogWatchLogger(LogWatch logWatch, String podName, CompletableFuture<Void> asyncLogger) {
            this.logWatch = logWatch;
            this.podName = podName;
            this.asyncLogger = asyncLogger;
        }

        @Override
        public void close() {
            this.asyncLogger.complete(null);
            this.logWatch.close();
        }
    }
}

