/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSetSpec;
import io.fabric8.kubernetes.api.model.apps.DaemonSetSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.jkube.kit.common.util.MapUtil;
import org.eclipse.jkube.kit.config.resource.MetaDataConfig;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.config.resource.ResourceConfig;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.model.Configuration;

public abstract class AbstractLabelEnricher
extends BaseEnricher {
    protected AbstractLabelEnricher(EnricherContext enricherContext, String name) {
        super(enricherContext, name);
    }

    abstract Map<String, String> createLabels(boolean var1, Map<String, String> var2);

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ServiceBuilder>(){

            public void visit(ServiceBuilder serviceBuilder) {
                Map selectors = AbstractLabelEnricher.this.processSelectors(Optional.ofNullable(serviceBuilder.buildSpec()).map(ServiceSpec::getSelector).orElse(new HashMap()), false, new Properties[]{AbstractLabelEnricher.this.getResourceConfigLabels().getService(), AbstractLabelEnricher.this.getResourceConfigLabels().getAll()});
                ((ServiceFluent.SpecNested)serviceBuilder.editOrNewSpec().addToSelector(selectors)).endSpec();
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder builder) {
                Map selectors = AbstractLabelEnricher.this.processSelectors(Optional.ofNullable(builder.buildSpec()).map(DeploymentSpec::getSelector).map(LabelSelector::getMatchLabels).orElse(new HashMap()), false, new Properties[]{AbstractLabelEnricher.this.getResourceConfigLabels().getDeployment(), AbstractLabelEnricher.this.getResourceConfigLabels().getPod(), AbstractLabelEnricher.this.getResourceConfigLabels().getAll()});
                ((DeploymentFluent.SpecNested)((DeploymentSpecFluent.SelectorNested)builder.editOrNewSpec().editOrNewSelector().withMatchLabels(selectors)).endSelector()).endSpec();
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder builder) {
                Map selectors = AbstractLabelEnricher.this.processSelectors(Optional.ofNullable(builder.buildSpec()).map(DeploymentConfigSpec::getSelector).orElse(new HashMap()), false, new Properties[]{AbstractLabelEnricher.this.getResourceConfigLabels().getPod(), AbstractLabelEnricher.this.getResourceConfigLabels().getAll()});
                ((DeploymentConfigFluent.SpecNested)builder.editOrNewSpec().addToSelector(selectors)).endSpec();
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<DaemonSetBuilder>(){

            public void visit(DaemonSetBuilder builder) {
                Map selectors = AbstractLabelEnricher.this.processSelectors(Optional.ofNullable(builder.buildSpec()).map(DaemonSetSpec::getSelector).map(LabelSelector::getMatchLabels).orElse(new HashMap()), true, new Properties[]{AbstractLabelEnricher.this.getResourceConfigLabels().getAll()});
                ((DaemonSetFluent.SpecNested)((DaemonSetSpecFluent.SelectorNested)builder.editOrNewSpec().editOrNewSelector().withMatchLabels(selectors)).endSelector()).endSpec();
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<ReplicationControllerBuilder>(){

            public void visit(ReplicationControllerBuilder builder) {
                Map selectors = AbstractLabelEnricher.this.processSelectors(Optional.ofNullable(builder.buildSpec()).map(ReplicationControllerSpec::getSelector).orElse(new HashMap()), false, new Properties[]{AbstractLabelEnricher.this.getResourceConfigLabels().getPod(), AbstractLabelEnricher.this.getResourceConfigLabels().getAll()});
                ((ReplicationControllerFluent.SpecNested)builder.editOrNewSpec().addToSelector(selectors)).endSpec();
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<ReplicaSetBuilder>(){

            public void visit(ReplicaSetBuilder builder) {
                Map selectors = AbstractLabelEnricher.this.processSelectors(Optional.ofNullable(builder.buildSpec()).map(ReplicaSetSpec::getSelector).map(LabelSelector::getMatchLabels).orElse(new HashMap()), false, new Properties[]{AbstractLabelEnricher.this.getResourceConfigLabels().getReplicaSet(), AbstractLabelEnricher.this.getResourceConfigLabels().getPod(), AbstractLabelEnricher.this.getResourceConfigLabels().getAll()});
                ((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.SelectorNested)builder.editOrNewSpec().editOrNewSelector().withMatchLabels(selectors)).endSelector()).endSpec();
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<StatefulSetBuilder>(){

            public void visit(StatefulSetBuilder builder) {
                Map selectors = AbstractLabelEnricher.this.processSelectors(Optional.ofNullable(builder.buildSpec()).map(StatefulSetSpec::getSelector).map(LabelSelector::getMatchLabels).orElse(new HashMap()), true, new Properties[]{AbstractLabelEnricher.this.getResourceConfigLabels().getPod(), AbstractLabelEnricher.this.getResourceConfigLabels().getAll()});
                ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)builder.editOrNewSpec().editOrNewSelector().withMatchLabels(selectors)).endSelector()).endSpec();
            }
        }});
    }

    public void enrich(PlatformMode platformMode, KubernetesListBuilder builder) {
        builder.accept(new Visitor[]{new TypedVisitor<ObjectMetaBuilder>(){

            public void visit(ObjectMetaBuilder element) {
                Map labels = AbstractLabelEnricher.this.processSelectors(Optional.ofNullable(element.build()).map(ObjectMeta::getLabels).orElse(new HashMap()), true, new Properties[0]);
                element.withLabels(labels);
            }
        }});
    }

    private Map<String, String> processSelectors(Map<String, String> selectors, boolean includeVersion, Properties ... labelPropertyList) {
        MapUtil.mergeIfAbsent(selectors, this.createLabels(includeVersion, MapUtil.mergeMaps((Properties[])labelPropertyList)));
        return selectors;
    }

    protected MetaDataConfig getResourceConfigLabels() {
        return Optional.ofNullable(this.getConfiguration()).map(Configuration::getResource).map(ResourceConfig::getLabels).orElse(MetaDataConfig.builder().build());
    }
}

