/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic;

import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluent;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;

public class RevisionHistoryEnricher
extends BaseEnricher {
    private static final String DEFAULT_NAME = "jkube-revision-history";
    private static final String DEFAULT_NUMBER_OF_REVISIONS = "2";

    public RevisionHistoryEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, DEFAULT_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        final Integer maxRevisionHistories = Configs.asInt((String)this.getConfig(Config.LIMIT));
        this.log.info("Adding revision history limit to %s", new Object[]{maxRevisionHistories});
        builder.accept(new Visitor[]{new TypedVisitor<DeploymentBuilder>(){

            public void visit(DeploymentBuilder item) {
                ((DeploymentFluent.SpecNested)item.editOrNewSpec().withRevisionHistoryLimit(maxRevisionHistories)).endSpec();
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder>(){

            public void visit(io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder item) {
                ((DeploymentFluent.SpecNested)item.editOrNewSpec().withRevisionHistoryLimit(maxRevisionHistories)).endSpec();
            }
        }});
        builder.accept(new Visitor[]{new TypedVisitor<DeploymentConfigBuilder>(){

            public void visit(DeploymentConfigBuilder item) {
                ((DeploymentConfigFluent.SpecNested)item.editOrNewSpec().withRevisionHistoryLimit(maxRevisionHistories)).endSpec();
            }
        }});
    }

    private static enum Config implements Configs.Config
    {
        LIMIT("limit", "2");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

