/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.enricher.generic.openshift;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceSpec;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.ProjectSpec;
import io.fabric8.openshift.api.model.ProjectStatus;
import io.fabric8.openshift.api.model.ProjectStatusBuilder;
import org.eclipse.jkube.kit.config.resource.PlatformMode;
import org.eclipse.jkube.kit.enricher.api.BaseEnricher;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.api.util.KubernetesResourceUtil;

public class ProjectEnricher
extends BaseEnricher {
    static final String ENRICHER_NAME = "jkube-openshift-project";

    public ProjectEnricher(JKubeEnricherContext context) {
        super((EnricherContext)context, ENRICHER_NAME);
    }

    public void create(PlatformMode platformMode, KubernetesListBuilder builder) {
        if (platformMode == PlatformMode.openshift) {
            for (HasMetadata item : builder.buildItems()) {
                if (!(item instanceof Namespace)) continue;
                Project project = this.convertToProject((Namespace)item);
                KubernetesResourceUtil.removeItemFromKubernetesBuilder((KubernetesListBuilder)builder, (HasMetadata)item);
                builder.addToItems(new HasMetadata[]{project});
            }
        }
    }

    private Project convertToProject(Namespace namespace) {
        ProjectBuilder builder = new ProjectBuilder();
        builder.withMetadata(namespace.getMetadata());
        if (namespace.getSpec() != null) {
            NamespaceSpec namespaceSpec = namespace.getSpec();
            ProjectSpec projectSpec = new ProjectSpec();
            if (namespaceSpec.getFinalizers() != null) {
                projectSpec.setFinalizers(namespaceSpec.getFinalizers());
            }
            builder.withSpec(projectSpec);
        }
        if (namespace.getStatus() != null) {
            ProjectStatus status = ((ProjectStatusBuilder)new ProjectStatusBuilder().withPhase(namespace.getStatus().getPhase())).build();
            builder.withStatus(status);
        }
        return builder.build();
    }
}

