/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.resource.helm;

import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class HelmParameter {
    private static final String GOLANG_EXPRESSION_REGEX = "\\{\\{.+}}";
    private boolean required;
    private String name;
    private Object value;

    boolean isString() {
        return this.value instanceof String;
    }

    boolean isGolangExpression() {
        return this.isString() && Stream.of(this.value.toString().split("\r?\n")).filter(StringUtils::isNotBlank).allMatch(s -> s.trim().matches(GOLANG_EXPRESSION_REGEX));
    }

    String toExpression() {
        if (this.isGolangExpression()) {
            return StringUtils.trimToEmpty((String)this.getValue().toString());
        }
        String requiredExpression = this.isRequired() ? "required \"A valid .Values." + this.getName() + " entry required!\" " : "";
        return "{{ " + requiredExpression + ".Values." + this.getName() + " }}";
    }

    public static HelmParameterBuilder builder() {
        return new HelmParameterBuilder();
    }

    public HelmParameterBuilder toBuilder() {
        return new HelmParameterBuilder().required(this.required).name(this.name).value(this.value);
    }

    public HelmParameter(boolean required, String name, Object value) {
        this.required = required;
        this.name = name;
        this.value = value;
    }

    public HelmParameter() {
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HelmParameter)) {
            return false;
        }
        HelmParameter other = (HelmParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HelmParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequired() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "HelmParameter(required=" + this.isRequired() + ", name=" + this.getName() + ", value=" + this.getValue() + ")";
    }

    public static class HelmParameterBuilder {
        private boolean required;
        private String name;
        private Object value;

        HelmParameterBuilder() {
        }

        public HelmParameterBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        public HelmParameterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public HelmParameterBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public HelmParameter build() {
            return new HelmParameter(this.required, this.name, this.value);
        }

        public String toString() {
            return "HelmParameter.HelmParameterBuilder(required=" + this.required + ", name=" + this.name + ", value=" + this.value + ")";
        }
    }
}

