/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.profile;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jkube.kit.config.resource.ProcessorConfig;

public class Profile
implements Comparable<Profile> {
    private static final AtomicInteger idCreator = new AtomicInteger(0);
    private final int id = idCreator.getAndIncrement();
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="extends")
    private String parentProfile;
    @JsonProperty(value="enricher")
    private ProcessorConfig enricherConfig;
    @JsonProperty(value="generator")
    private ProcessorConfig generatorConfig;
    @JsonProperty(value="watcher")
    private ProcessorConfig watcherConfig;
    @JsonProperty(value="order")
    private int order;

    public Profile() {
    }

    public Profile(Profile profile) {
        this();
        this.name = profile.name;
        this.parentProfile = profile.parentProfile;
        this.order = profile.order;
        this.enricherConfig = ProcessorConfig.cloneProcessorConfig((ProcessorConfig)profile.enricherConfig);
        this.generatorConfig = ProcessorConfig.cloneProcessorConfig((ProcessorConfig)profile.generatorConfig);
        this.watcherConfig = ProcessorConfig.cloneProcessorConfig((ProcessorConfig)profile.watcherConfig);
    }

    public Profile(Profile profileA, Profile profileB) {
        this();
        this.name = profileA.name;
        if (!profileB.name.equals(profileA.getName())) {
            throw new IllegalArgumentException(String.format("Cannot merge to profiles with different names (%s vs. %s)", profileA.getName(), profileB.getName()));
        }
        if (profileA.order >= profileB.order) {
            this.order = profileA.order;
            this.enricherConfig = ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{profileA.enricherConfig, profileB.enricherConfig});
            this.generatorConfig = ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{profileA.generatorConfig, profileB.generatorConfig});
            this.watcherConfig = ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{profileA.watcherConfig, profileB.watcherConfig});
            this.parentProfile = Optional.ofNullable(profileA.parentProfile).orElse(profileB.parentProfile);
        } else {
            this.order = profileB.order;
            this.enricherConfig = ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{profileB.enricherConfig, profileA.enricherConfig});
            this.generatorConfig = ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{profileB.generatorConfig, profileA.generatorConfig});
            this.watcherConfig = ProcessorConfig.mergeProcessorConfigs((ProcessorConfig[])new ProcessorConfig[]{profileB.watcherConfig, profileA.watcherConfig});
            this.parentProfile = Optional.ofNullable(profileB.parentProfile).orElse(profileA.parentProfile);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getParentProfile() {
        return this.parentProfile;
    }

    public ProcessorConfig getEnricherConfig() {
        return this.enricherConfig;
    }

    public ProcessorConfig getGeneratorConfig() {
        return this.generatorConfig;
    }

    public ProcessorConfig getWatcherConfig() {
        return this.watcherConfig;
    }

    public void setEnricherConfig(ProcessorConfig config) {
        this.enricherConfig = config;
    }

    public void setGeneratorConfig(ProcessorConfig config) {
        this.generatorConfig = config;
    }

    public void setWatcherConfig(ProcessorConfig config) {
        this.watcherConfig = config;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public int compareTo(Profile o) {
        int orderDiff = this.order - o.order;
        if (orderDiff != 0) {
            return orderDiff;
        }
        return this.id - o.id;
    }
}

