/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics;

import java.util.EnumSet;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Timer;

public enum MetricType {
    CONCURRENT_GAUGE("concurrent gauge", ConcurrentGauge.class),
    COUNTER("counter", Counter.class),
    GAUGE("gauge", Gauge.class),
    METERED("meter", Meter.class),
    HISTOGRAM("histogram", Histogram.class),
    TIMER("timer", Timer.class),
    INVALID("invalid", null);

    private String type;
    private Class<?> classtype;

    private MetricType(String type, Class<?> classtype) {
        this.type = type;
        this.classtype = classtype;
    }

    public String toString() {
        return this.type;
    }

    public static MetricType from(String in) {
        EnumSet<MetricType> enumSet = EnumSet.allOf(MetricType.class);
        for (MetricType u : enumSet) {
            if (!u.type.equals(in)) continue;
            return u;
        }
        throw new IllegalArgumentException(in + " is not a valid MetricType");
    }

    public static MetricType from(Class<?> in) {
        EnumSet<MetricType> enumSet = EnumSet.allOf(MetricType.class);
        for (MetricType u : enumSet) {
            if (u.classtype == null || !u.classtype.isAssignableFrom(in)) continue;
            return u;
        }
        throw new IllegalArgumentException(in + " is not a valid metric type");
    }
}

