/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.core;

import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.ReferenceType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.slf4j.LoggerFactory;

public class Reference {
    private final NodeId sourceNodeId;
    private final NodeId referenceTypeId;
    private final ExpandedNodeId targetNodeId;
    private final NodeClass targetNodeClass;
    private final boolean forward;
    public static final Predicate<Reference> HAS_COMPONENT_PREDICATE = reference -> reference.isForward() && Identifiers.HasComponent.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_PROPERTY_PREDICATE = reference -> reference.isForward() && Identifiers.HasProperty.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_TYPE_DEFINITION_PREDICATE = reference -> reference.isForward() && Identifiers.HasTypeDefinition.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_EVENT_SOURCE_PREDICATE = reference -> reference.isForward() && Identifiers.HasEventSource.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_NOTIFIER_PREDICATE = reference -> reference.isForward() && Identifiers.HasNotifier.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> ORGANIZES_PREDICATE = reference -> reference.isForward() && Identifiers.Organizes.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_DESCRIPTION_PREDICATE = reference -> reference.isForward() && Identifiers.HasDescription.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_MODELLING_RULE_PREDICATE = reference -> reference.isForward() && Identifiers.HasModellingRule.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> ALWAYS_GENERATES_EVENT_PREDICATE = reference -> reference.isForward() && Identifiers.AlwaysGeneratesEvent.equals((Object)reference.getReferenceTypeId());

    public Reference(NodeId sourceNodeId, NodeId referenceTypeId, ExpandedNodeId targetNodeId, NodeClass targetNodeClass, boolean forward) {
        this.sourceNodeId = sourceNodeId;
        this.referenceTypeId = referenceTypeId;
        this.targetNodeId = targetNodeId;
        this.targetNodeClass = targetNodeClass;
        this.forward = forward;
    }

    public NodeId getSourceNodeId() {
        return this.sourceNodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public ExpandedNodeId getTargetNodeId() {
        return this.targetNodeId;
    }

    public NodeClass getTargetNodeClass() {
        return this.targetNodeClass;
    }

    public boolean isForward() {
        return this.forward;
    }

    public boolean isInverse() {
        return !this.isForward();
    }

    public boolean subtypeOf(NodeId superTypeId, Map<NodeId, ReferenceType> referenceTypes) {
        return this.subtypeOf(this.referenceTypeId, superTypeId, referenceTypes);
    }

    private boolean subtypeOf(NodeId typeId, NodeId superTypeId, Map<NodeId, ReferenceType> referenceTypes) {
        ReferenceType referenceType = referenceTypes.get(typeId);
        if (referenceType == null) {
            LoggerFactory.getLogger(this.getClass()).warn("Unknown reference type: {}", (Object)typeId);
            return false;
        }
        return referenceType.getSuperTypeId().map(id -> id.equals((Object)superTypeId) || this.subtypeOf((NodeId)id, superTypeId, referenceTypes)).orElse(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference reference = (Reference)o;
        return this.forward == reference.forward && this.referenceTypeId.equals((Object)reference.referenceTypeId) && this.sourceNodeId.equals((Object)reference.sourceNodeId) && this.targetNodeClass == reference.targetNodeClass && this.targetNodeId.equals((Object)reference.targetNodeId);
    }

    public int hashCode() {
        int result = this.sourceNodeId.hashCode();
        result = 31 * result + this.referenceTypeId.hashCode();
        result = 31 * result + this.targetNodeId.hashCode();
        result = 31 * result + this.targetNodeClass.hashCode();
        result = 31 * result + (this.forward ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Reference{sourceNodeId=" + this.sourceNodeId + ", referenceTypeId=" + this.referenceTypeId + ", targetNodeId=" + this.targetNodeId + ", targetNodeClass=" + this.targetNodeClass + ", forward=" + this.forward + '}';
    }
}

