/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.core.model;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;

public class QualifiedProperty<T> {
    private final String namespaceUri;
    private final String browseName;
    private final NodeId dataType;
    private final Integer valueRank;
    private final Class<T> javaType;

    public QualifiedProperty(String namespaceUri, String browseName, NodeId dataType, Integer valueRank, Class<T> javaType) {
        this.namespaceUri = namespaceUri;
        this.browseName = browseName;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.javaType = javaType;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getBrowseName() {
        return this.browseName;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public Integer getValueRank() {
        return this.valueRank;
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public Optional<QualifiedName> getQualifiedName(NamespaceTable namespaceTable) {
        UShort namespaceIndex = namespaceTable.getIndex(this.namespaceUri);
        if (namespaceIndex != null) {
            return Optional.of(new QualifiedName(namespaceIndex, this.browseName));
        }
        return Optional.empty();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespaceUri", (Object)this.namespaceUri).add("browseName", (Object)this.browseName).add("dataType", (Object)this.dataType).add("valueRank", (Object)this.valueRank).add("javaType", this.javaType).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedProperty that = (QualifiedProperty)o;
        return Objects.equals(this.namespaceUri, that.namespaceUri) && Objects.equals(this.browseName, that.browseName) && Objects.equals(this.dataType, that.dataType) && Objects.equals(this.valueRank, that.valueRank) && Objects.equals(this.javaType, that.javaType);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceUri, this.browseName, this.dataType, this.valueRank, this.javaType);
    }
}

