/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public class NamespaceTable {
    public static final String OPC_UA_NAMESPACE = "http://opcfoundation.org/UA/";
    private final BiMap<UShort, String> uriTable = HashBiMap.create();

    public NamespaceTable() {
        this.uriTable.put((Object)Unsigned.ushort(0), (Object)OPC_UA_NAMESPACE);
    }

    public synchronized UShort addUri(String uri) {
        UShort index = Unsigned.ushort(1);
        while (this.uriTable.containsKey((Object)index)) {
            if ((index = Unsigned.ushort(index.intValue() + 1)).intValue() != 65535) continue;
            throw new UaRuntimeException(0x80020000L, "uri table full");
        }
        this.uriTable.put((Object)index, (Object)uri);
        return index;
    }

    public synchronized void putUri(String uri, UShort index) {
        this.uriTable.put((Object)index, (Object)uri);
    }

    public synchronized String getUri(UShort index) {
        return (String)this.uriTable.get((Object)index);
    }

    public synchronized UShort getIndex(String uri) {
        return (UShort)this.uriTable.inverse().getOrDefault((Object)uri, null);
    }

    public synchronized void update(Consumer<BiMap<UShort, String>> uriTableConsumer) {
        uriTableConsumer.accept(this.uriTable);
    }

    public synchronized String[] toArray() {
        List<String> uris = this.uriTable.entrySet().stream().sorted((e1, e2) -> ((UShort)e1.getKey()).intValue() - ((UShort)e2.getKey()).intValue()).map(Map.Entry::getValue).collect(Collectors.toList());
        return uris.toArray(new String[uris.size()]);
    }
}

