/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.messages;

import io.netty.buffer.ByteBuf;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.messages.AcknowledgeMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.HelloMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;

public class TcpMessageDecoder {
    public static HelloMessage decodeHello(ByteBuf buffer) throws UaException {
        MessageType messageType = MessageType.fromMediumInt(buffer.readMedium());
        char chunkType = (char)buffer.readByte();
        buffer.skipBytes(4);
        assert (messageType == MessageType.Hello && chunkType == 'F');
        return HelloMessage.decode(buffer);
    }

    public static AcknowledgeMessage decodeAcknowledge(ByteBuf buffer) throws UaException {
        MessageType messageType = MessageType.fromMediumInt(buffer.readMedium());
        char chunkType = (char)buffer.readByte();
        buffer.skipBytes(4);
        assert (messageType == MessageType.Acknowledge && chunkType == 'F');
        return AcknowledgeMessage.decode(buffer);
    }

    public static ErrorMessage decodeError(ByteBuf buffer) throws UaException {
        MessageType messageType = MessageType.fromMediumInt(buffer.readMedium());
        char chunkType = (char)buffer.readByte();
        buffer.skipBytes(4);
        assert (messageType == MessageType.Error && chunkType == 'F');
        return ErrorMessage.decode(buffer);
    }
}

